/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import java.io.File;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SdkBasePathValidator
implements IValidator<String> {
    public IStatus validate(String basePath) {
        if (Objects.toString(basePath, "").isEmpty()) {
            return ValidationStatus.error((String)Messages.SdkBasePathValidator_error_empty_path);
        }
        String completedSdkPath = null;
        try {
            completedSdkPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(basePath, true);
            if (completedSdkPath == null || completedSdkPath.isEmpty()) {
                return ValidationStatus.error((String)Messages.SdkBasePathValidator_error_empty_path);
            }
        }
        catch (CoreException ce) {
            String errorMessage = NLS.bind((String)Messages.SdkBasePathValidator_error_path_not_resolved, (Object)basePath, (Object)ce.getMessage());
            if (130 == ce.getStatus().getCode()) {
                errorMessage = NLS.bind((String)Messages.SdkBasePathValidator_error_path_has_recursive_variables_declarations, (Object)basePath);
            }
            return ValidationStatus.error((String)errorMessage);
        }
        File file = new File(completedSdkPath);
        if (!file.exists()) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkBasePathValidator_error_path_not_exists, (Object)completedSdkPath));
        }
        if (!file.canRead()) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkBasePathValidator_error_path_not_readable, (Object)completedSdkPath));
        }
        if (!file.isDirectory()) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkBasePathValidator_error_path_not_directory, (Object)completedSdkPath));
        }
        return Status.OK_STATUS;
    }
}

