/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkSymbolsValidator
implements IValidator<String> {
    private static final String SPACE = " ";
    private static final String EQUAL = "=";
    private static final String QUOTE = "\"";
    private static final int SYMBOL_LENGTH = 512;
    private static final Pattern SYMBOL_NAME_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    private boolean isInitialInput;
    private List<String> existingSymbols;

    public IStatus validate(String symbolString) {
        String[] splittedSymbol;
        MultiStatus validationStatuses = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        if (symbolString == null || symbolString.isEmpty()) {
            validationStatuses.add(ValidationStatus.error((String)Messages.SdkSymbolValidator_error_symbol_is_empty));
            return validationStatuses;
        }
        if (!this.isInitialInput && this.existingSymbols != null && this.existingSymbols.contains(symbolString)) {
            validationStatuses.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkSymbolValidator_error_symbol_exists, (Object)symbolString)));
        }
        if (symbolString.length() > 512) {
            validationStatuses.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkSymbolValidator_error_symbol_length, (Object)512)));
        }
        if ((splittedSymbol = symbolString.split(EQUAL, 2)).length > 0) {
            String symbolName = splittedSymbol[0];
            validationStatuses.addAll((IStatus)this.validateNameCharacters(symbolName));
            if (splittedSymbol.length > 1) {
                validationStatuses.add(SdkSymbolsValidator.validateValue(symbolName, splittedSymbol[1]));
            }
        }
        if (this.isInitialInput) {
            this.isInitialInput = false;
        }
        return !validationStatuses.isOK() ? validationStatuses : Status.OK_STATUS;
    }

    public void setIsInitialInput(boolean isInitialInput) {
        this.isInitialInput = isInitialInput;
    }

    public void setExistingSymbols(List<String> existingSymbols) {
        this.existingSymbols = existingSymbols;
    }

    private MultiStatus validateNameCharacters(String symbolName) {
        MultiStatus validationStatuses = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        if (symbolName.isEmpty()) {
            validationStatuses.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkSymbolValidator_error_symbol_start_symbol, (Object)symbolName)));
        }
        if (symbolName.length() > 0) {
            Matcher matcher = SYMBOL_NAME_PATTERN.matcher(symbolName);
            matcher.reset(symbolName.substring(0, 1));
            if (!matcher.matches()) {
                validationStatuses.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkSymbolValidator_error_symbol_start_symbol, (Object)symbolName)));
            }
            matcher.reset(symbolName);
            if (!matcher.matches()) {
                validationStatuses.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkSymbolValidator_error_symbol_characters, (Object)symbolName)));
            }
        }
        return validationStatuses;
    }

    private static IStatus validateValue(String symbolName, String symbolValue) {
        if (!(!symbolValue.contains(SPACE) || symbolValue.startsWith(QUOTE) && symbolValue.endsWith(QUOTE))) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkSymbolValidator_error_symbol_value_with_spaces_is_not_quoted, (Object)symbolName));
        }
        return Status.OK_STATUS;
    }
}

