/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.project.configuration.core.validators.OptionsValidator;
import com.nxp.s32ds.cle.cdt.project.configuration.core.validators.ProjectSettingsValidators;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkAction;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.MessageAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectOptionAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectOptionCleanupAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectOptionUpdateAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFileRemoveAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderCleanupAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderCreateAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderRemoveAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHolder;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectOptionValidateAction
extends ProjectOptionAction {
    private boolean isCheckEquality = true;

    public ProjectOptionValidateAction(String optionId, String optionValue, Set<SdkAction> validSuccessorActions) {
        super(optionId, optionValue, SdkActionOperations.OPTION_VALUE_CHECK);
        if (validSuccessorActions != null) {
            this.successorActions.addAll(validSuccessorActions);
        }
    }

    public ProjectOptionValidateAction(Element checkOptionValueElement, VariablesHolder sdkVariables) {
        super(checkOptionValueElement);
        this.initialize(checkOptionValueElement, sdkVariables);
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        if (this.isApplicable(configuration)) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
            OptionsValidator optionValidator = ProjectSettingsValidators.getOptionValidator();
            IStatus status = optionValidator.validateOption(configuration, this.optionId, this.optionValue, this.isCheckEquality);
            if (status.isOK() && !this.successorActions.isEmpty()) {
                this.successorActions.forEach(action -> result.add(action.execute(project, configuration)));
            } else {
                result.add(status);
            }
            return result;
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public IStatus postExecute(IProject project, IConfiguration configuration) {
        return Status.OK_STATUS;
    }

    @Override
    protected Element createElement(Document document) {
        return document.createElement("checkOptionValue");
    }

    @Override
    protected void convertAttributesToXml(Document document, Element element) {
        super.convertAttributesToXml(document, element);
        element.setAttribute("isEq", String.valueOf(this.isCheckEquality));
        this.successorActions.forEach(action -> action.convertToXml(document, element));
    }

    private void initialize(Element checkOptionValueElement, VariablesHolder sdkVariables) {
        String isEqAttribute = checkOptionValueElement.getAttribute("isEq");
        if (isEqAttribute != null && !isEqAttribute.isEmpty()) {
            this.isCheckEquality = Boolean.parseBoolean(isEqAttribute);
        }
        NodeList actionElements = checkOptionValueElement.getChildNodes();
        int i = 0;
        while (i < actionElements.getLength()) {
            block34: {
                Node actionNode = actionElements.item(i);
                if (!(actionNode instanceof Element)) break block34;
                Element actionElement = (Element)actionNode;
                VariablesHelper.performSdkVariablesSubstitution(actionElement, sdkVariables);
                actionElement.setUserData("action_holder", checkOptionValueElement.getUserData("action_holder"), null);
                switch (actionElement.getNodeName()) {
                    case "createProjectFolder": {
                        this.successorActions.add(new ProjectResourceFolderCreateAction(actionElement));
                        break;
                    }
                    case "cleanupProjectFolder": {
                        this.successorActions.add(new ProjectResourceFolderCleanupAction(actionElement));
                        break;
                    }
                    case "removeProjectFolder": {
                        this.successorActions.add(new ProjectResourceFolderRemoveAction(actionElement));
                        break;
                    }
                    case "removeProjectFile": {
                        this.successorActions.add(new ProjectResourceFileRemoveAction(actionElement));
                        break;
                    }
                    case "addOptionValue": 
                    case "setOptionValue": 
                    case "removeOptionValue": {
                        this.successorActions.add(new ProjectOptionUpdateAction(actionElement));
                        break;
                    }
                    case "cleanupOptionValue": {
                        this.successorActions.add(new ProjectOptionCleanupAction(actionElement));
                        break;
                    }
                    case "checkOptionValue": {
                        this.successorActions.add(new ProjectOptionValidateAction(actionElement, sdkVariables));
                        break;
                    }
                    case "message": {
                        this.successorActions.add(new MessageAction(actionElement));
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isCheckEquality ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectOptionValidateAction)) {
            return false;
        }
        return this.isCheckEquality ^ ((ProjectOptionValidateAction)obj).isCheckEquality;
    }
}

