/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionMessageType;
import java.util.Objects;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkActionMessage {
    private SdkActionMessageType type;
    private String text;

    public SdkActionMessage(String text, SdkActionMessageType type) {
        this.text = text;
        this.type = type;
    }

    public SdkActionMessage(Element element) {
        this.text = element.getAttribute("text");
        String messageTypeAttribute = element.getAttribute("type");
        this.type = Objects.requireNonNull(SdkActionMessageType.getMessageType((String)messageTypeAttribute), NLS.bind((String)"Unsupported action message type: {0}.", (Object)messageTypeAttribute));
    }

    public String getText() {
        return this.text != null ? this.text : "";
    }

    public SdkActionMessageType getType() {
        return this.type;
    }

    public void convertToXml(Document document, Element actionElement) {
        Element element = document.createElement("message");
        element.setAttribute("type", this.type.getAttributeValue());
        element.setAttribute("text", this.text);
        actionElement.appendChild(element);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkActionMessage)) {
            return false;
        }
        SdkActionMessage other = (SdkActionMessage)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return this.type == other.type;
    }
}

