/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderAction;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class ProjectResourceFolderCreateAction
extends ProjectResourceFolderAction {
    public ProjectResourceFolderCreateAction(Element element) {
        super(element);
        this.isIncludeResourceToBuildPath = Boolean.parseBoolean(element.getAttribute("buildPath"));
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        if (!project.isAccessible()) {
            return new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectFolderCreateAction_error_project_not_accessible, (Object)this.pathsToString(), (Object)project));
        }
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        for (IResource resource : this.getResources(project)) {
            IFolder folder = (IFolder)resource;
            try {
                String[] pathSegments = folder.getProjectRelativePath().segments();
                IFolder subfolder = project.getFolder(pathSegments[0]);
                if (!subfolder.exists()) {
                    subfolder.create(true, false, (IProgressMonitor)new NullProgressMonitor());
                }
                int i = 1;
                while (i < pathSegments.length) {
                    subfolder = subfolder.getFolder(pathSegments[i]);
                    subfolder.create(true, false, (IProgressMonitor)new NullProgressMonitor());
                    ++i;
                }
                if (!this.isIncludeResourceToBuildPath) continue;
                result.addAll(this.includeResourceToBuildPath((IResource)folder, configuration));
            }
            catch (CoreException ce) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectFolderCreateAction_error_execute_exception, (Object)folder.getProjectRelativePath().toOSString()), (Throwable)ce));
            }
        }
        return result;
    }

    @Override
    protected boolean isPathValid(String path) {
        return super.isPathValid(path) && !path.contains("*");
    }

    @Override
    protected String getElementName() {
        return "createProjectFolder";
    }

    @Override
    protected Collection<IResource> getResources(IProject project) {
        return this.paths.stream().map(arg_0 -> ((IProject)project).getFolder(arg_0)).collect(Collectors.toList());
    }
}

