/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

public class ChangedAttachmentData {
    private final SdkDescriptor sdkDescriptor;
    private final Collection<IConfiguration> attachConfigurations;
    private final Collection<IConfiguration> detachConfigurations;

    public ChangedAttachmentData(SdkDescriptor sdk, Collection<IConfiguration> attachConfigurations, Collection<IConfiguration> detachConfigurations) {
        this.sdkDescriptor = Objects.requireNonNull(sdk);
        this.attachConfigurations = Objects.requireNonNull(attachConfigurations);
        this.detachConfigurations = Objects.requireNonNull(detachConfigurations);
    }

    public ChangedAttachmentData(SdkDescriptor sdk) {
        this.sdkDescriptor = Objects.requireNonNull(sdk);
        this.attachConfigurations = Collections.emptyList();
        this.detachConfigurations = Collections.emptyList();
    }

    public SdkDescriptor getSdkDescriptor() {
        return this.sdkDescriptor;
    }

    public Collection<IConfiguration> getAttachConfigurations() {
        return this.attachConfigurations;
    }

    public Collection<IConfiguration> getDetachConfigurations() {
        return this.detachConfigurations;
    }

    public boolean isEmpty() {
        return this.getAttachConfigurations().isEmpty() && this.getDetachConfigurations().isEmpty();
    }

    public static ChangedAttachmentData changeSdkAttachmentData(SdkDescriptor sdkDescriptor, IProject project) {
        String sdkId = sdkDescriptor.getId();
        int[] newAttachFlags = ChangedAttachmentData.getSelectedAttachConfigurations(sdkId, false);
        if (newAttachFlags.length == 0) {
            return new ChangedAttachmentData(sdkDescriptor);
        }
        int[] oldAttachFlags = ChangedAttachmentData.getSelectedAttachConfigurations(sdkId, true);
        int selectedConfigsCount = newAttachFlags.length;
        if (oldAttachFlags.length == 0) {
            oldAttachFlags = new int[selectedConfigsCount];
        }
        ArrayList<IConfiguration> toAdd = new ArrayList<IConfiguration>();
        ArrayList<IConfiguration> toDel = new ArrayList<IConfiguration>();
        HashMap<IConfiguration, Integer> confsAtachInfo = new HashMap<IConfiguration, Integer>();
        List configurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        int i = 0;
        while (i < selectedConfigsCount && i < configurations.size()) {
            IConfiguration configuration = (IConfiguration)configurations.get(i);
            confsAtachInfo.put(configuration, i);
            if (newAttachFlags[i] == 1 && oldAttachFlags[i] == 0) {
                toAdd.add(configuration);
            } else if (newAttachFlags[i] == 0 && oldAttachFlags[i] == 1) {
                toDel.add(configuration);
            }
            ++i;
        }
        return new ChangedAttachmentData(sdkDescriptor, toAdd, toDel);
    }

    private static int[] getSelectedAttachConfigurations(String sdkId, boolean isBackup) {
        List<IStatus> states = null;
        states = isBackup ? SdkAttachStatusesHolder.INSTANCE.getBackupSDKsAttachStates().get(sdkId) : SdkAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates().get(sdkId);
        if (states == null) {
            return new int[0];
        }
        return states.stream().map(status -> status.equals(SdkAttachStatuses.OK_SDK_ATTACHED) ? 1 : 0).mapToInt(i -> i).toArray();
    }
}

