/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionCheck;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionCheckDebugger
implements ConditionCheck {
    public static final String CONDITION_CHECK_DEBUGGERS_ATTRIBUTE = "debuggers";
    private final Set<String> debuggers;

    ConditionCheckDebugger(Element conditionCheckElement) {
        this.debuggers = Arrays.stream(conditionCheckElement.getAttribute(CONDITION_CHECK_DEBUGGERS_ATTRIBUTE).split(",")).map(String::trim).filter(debuggerId -> !debuggerId.isEmpty()).collect(Collectors.toSet());
    }

    public boolean check(Object checkCondition) {
        if (checkCondition instanceof IConfiguration) {
            if (!this.debuggers.isEmpty()) {
                if (!ConditionCheckDebugger.getDeviceDebuggerIds((IConfiguration)checkCondition).stream().anyMatch(this.debuggers::contains)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void convertToXml(Document document, Element conditionElement) {
        Element checkElement = document.createElement("check");
        checkElement.setAttribute(CONDITION_CHECK_DEBUGGERS_ATTRIBUTE, String.join((CharSequence)",", this.debuggers));
        conditionElement.appendChild(checkElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.debuggers == null ? 0 : this.debuggers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionCheckDebugger)) {
            return false;
        }
        ConditionCheckDebugger other = (ConditionCheckDebugger)obj;
        return !(this.debuggers == null ? other.debuggers != null : !this.debuggers.equals(other.debuggers));
    }

    private static List<String> getDeviceDebuggerIds(IConfiguration configuration) {
        List<String> debuggerIds;
        IProject project = configuration.getOwner().getProject();
        String projectFamilyId = Objects.toString(ConditionCheckDebugger.getProjectContextParameter(project, "com.nxp.s32ds.cle.runtime.hardware.registry.family.id"), "");
        String projectDeviceId = Objects.toString(ConditionCheckDebugger.getProjectContextParameter(project, "com.nxp.s32ds.cle.runtime.hardware.registry.device.id"), "");
        String projectDeviceRevisionId = Objects.toString(ConditionCheckDebugger.getProjectContextParameter(project, "com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id"), "");
        String projectCoreId = Objects.toString(ConditionCheckDebugger.getProjectContextParameter(project, "com.nxp.s32ds.cle.runtime.hardware.registry.core.id"), "");
        IToolChain toolChain = configuration.getToolChain();
        do {
            debuggerIds = ConditionCheckDebugger.getDebuggerIds(projectFamilyId, projectDeviceId, projectDeviceRevisionId, projectCoreId, toolChain.getBaseId());
        } while ((toolChain = toolChain.getSuperClass()) != null && debuggerIds.isEmpty());
        return debuggerIds != null ? debuggerIds : Collections.emptyList();
    }

    private static List<String> getDebuggerIds(String familyId, String deviceId, String deviceRevisionId, String coreId, String toolChainId) {
        List<String> debuggerIds = ConditionCheckDebugger.getDebuggerIdsFromAllFeatures(familyId, deviceId, deviceRevisionId, coreId, toolChainId);
        if (debuggerIds.isEmpty()) {
            debuggerIds = ConditionCheckDebugger.getDebuggerIdsFromDeviceDebuggerDescriptor(familyId, deviceId, deviceRevisionId, toolChainId);
        }
        return debuggerIds;
    }

    private static List<String> getDebuggerIdsFromDeviceId(String deviceId, String deviceRevisionId, String toolChainId) {
        if (!deviceId.isEmpty()) {
            if (!deviceRevisionId.isEmpty()) {
                return DeviceCoreDebuggerDescriptors.getDebuggersByDeviceRevisionConditions((String)deviceId, (String)toolChainId, (String)deviceRevisionId);
            }
            return DeviceCoreDebuggerDescriptors.getDebuggersByDeviceToolchain((String)deviceId, (String)toolChainId);
        }
        return Collections.emptyList();
    }

    private static List<String> getDebuggerIdsFromFamilyCoreId(String familyId, String deviceRevisionId, String coreId, String toolChainId) {
        if (!familyId.isEmpty()) {
            return DeviceCoreDebuggerDescriptors.getDebuggersByFamilyConditions((String)familyId, (String)toolChainId, (String)coreId, (String)deviceRevisionId, null, null);
        }
        return Collections.emptyList();
    }

    private static List<String> getDebuggerIdsFromAllFeatures(String familyId, String deviceId, String deviceRevisionId, String coreId, String toolChainId) {
        List<String> debuggerIds = ConditionCheckDebugger.getDebuggerIdsFromDeviceId(deviceId, deviceRevisionId, toolChainId);
        return !debuggerIds.isEmpty() ? debuggerIds : ConditionCheckDebugger.getDebuggerIdsFromFamilyCoreId(familyId, deviceRevisionId, coreId, toolChainId);
    }

    private static List<String> getDebuggerIdsFromDeviceDebuggerDescriptor(String familyId, String deviceId, String deviceRevisionId, String toolChainId) {
        List deviceDebuggerDescriptors = new ArrayList();
        if (!deviceId.isEmpty()) {
            deviceDebuggerDescriptors = !deviceRevisionId.isEmpty() ? DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceId, (String)deviceRevisionId, (String)toolChainId) : DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)deviceId, (String)toolChainId);
        } else if (!familyId.isEmpty()) {
            deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptorByFamily((String)familyId, (String)toolChainId);
        }
        return deviceDebuggerDescriptors.stream().map(DeviceDebuggerDescriptor::getDebuggerId).collect(Collectors.toList());
    }

    private static String getProjectContextParameter(IProject project, String attributeKey) {
        return new ProjectContextSettings(project).getAttributeByKey(attributeKey);
    }
}

