/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionGroup;
import com.nxp.s32ds.cle.cdt.sdk.core.action.SdkActionsHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.condition.ConditionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.SdkActionsHolderImpl;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.condition.ConditionGroupImpl;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentsHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.fragment.FragmentsHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.AbstractResourceTagsConverter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHolder;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSdkDescriptorParser {
    protected Element sdkElement;
    protected VariablesHolder sdkVariables;
    protected FragmentsHolder sdkFragments;
    protected String sdkDescriptorPath;
    protected boolean isSdkLoadedByUser;
    protected String sdkId;
    protected String basePath;
    protected SdkType sdkType;
    private List<SdkActionsHolder> actionsHolders;
    private List<ConditionGroup> conditionsGroups;

    protected AbstractSdkDescriptorParser() {
        this.sdkVariables = VariablesHolder.emptyHolder();
        this.sdkFragments = FragmentsHolder.emptyHolder();
        this.actionsHolders = new ArrayList<SdkActionsHolder>();
        this.conditionsGroups = new ArrayList<ConditionGroup>();
    }

    protected AbstractSdkDescriptorParser(VariablesHolder sdkVariables, FragmentsHolder sdkFragments) {
        this.sdkVariables = sdkVariables != null ? sdkVariables : VariablesHolder.emptyHolder();
        this.sdkFragments = sdkFragments != null ? sdkFragments : FragmentsHolder.emptyHolder();
        this.actionsHolders = new ArrayList<SdkActionsHolder>();
        this.conditionsGroups = new ArrayList<ConditionGroup>();
    }

    public SdkDescriptor parseSdkElement(Element element) throws LoadSdkException {
        return this.parseSdkElement(element, (IProgressMonitor)new NullProgressMonitor());
    }

    public SdkDescriptor parseSdkElement(Element element, IProgressMonitor progressMonitor) throws LoadSdkException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        this.sdkElement = element;
        FragmentsHelper.performSdkFragmentsSubstitution(this.sdkElement, this.sdkFragments);
        VariablesHelper.performSdkVariablesSubstitution(this.sdkElement, this.sdkVariables);
        this.sdkId = SdkDescriptorUtils.makeId((Element)this.sdkElement);
        this.createSdkHeader();
        subMonitor.worked(ProgressCounter.ParseSDK.getValue());
        this.createRootToolChain();
        subMonitor.worked(ProgressCounter.ParseSDK.getValue());
        this.createToolChains();
        subMonitor.worked(ProgressCounter.ParseSDK.getValue());
        this.parseEnvironment(this.sdkElement);
        this.performResourceTagsConversion(this.sdkId, this.sdkElement);
        Collection<Element> childrens = AbstractSdkDescriptorParser.getChildElements(this.sdkElement, "toolchain");
        int len = childrens.size();
        for (Element toolChainElement : childrens) {
            VariablesHelper.performSdkVariablesSubstitution(toolChainElement, this.sdkVariables);
            this.performResourceTagsConversion(this.basePath, toolChainElement);
            subMonitor.worked(ProgressCounter.ParseSDK.getValue() / len);
        }
        this.unregisterSdk(this.sdkId);
        subMonitor.worked(ProgressCounter.ParseSDK.getValue());
        return this.createSdk((IProgressMonitor)subMonitor.split(ProgressCounter.CreateSDK.getValue()));
    }

    protected SdkDescriptor createSdk() {
        return this.createSdk((IProgressMonitor)new NullProgressMonitor());
    }

    protected SdkDescriptor createSdk(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)((this.conditionsGroups.size() + this.actionsHolders.size()) * ProgressCounter.TotalWork.getValue() / ProgressCounter.RegisterGroupAndActions.getValue() + ProgressCounter.RegisterDescriptor.getValue()));
        IStatus status = SdkDescriptorsRegitsrationHelper.registerSdkDescriptors((Element)this.sdkElement, (SdkType)this.sdkType, (IProgressMonitor)subMonitor.split(ProgressCounter.RegisterDescriptor.getValue()));
        if (status.isOK()) {
            this.conditionsGroups.forEach(conditionGroup -> {
                ConditionsHolder.INSTANCE.registerConditions(this.sdkId, (ConditionGroup)conditionGroup);
                subMonitor.worked(ProgressCounter.ProcessedUnit.getValue());
            });
            this.actionsHolders.forEach(actionsHolder -> {
                SdkActionsHandler.INSTANCE.registerSdkActions(this.sdkId, (SdkActionsHolder)actionsHolder);
                subMonitor.worked(ProgressCounter.ProcessedUnit.getValue());
            });
            subMonitor.done();
            return SdkDescriptors.getSdkDescriptor((String)this.sdkId);
        }
        subMonitor.done();
        return null;
    }

    protected void unregisterSdk(String sdkId) {
        ConditionsHolder.INSTANCE.unregisterConditions(sdkId);
        SdkActionsHandler.INSTANCE.unregisterSdkActions(sdkId);
        SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)sdkId);
    }

    protected String getSdkBasePath() {
        return this.basePath;
    }

    private void createSdkHeader() throws LoadSdkException {
        IStatus status = Status.OK_STATUS;
        if (SdkManagementUtils.isSdkExists(this.sdkId)) {
            status = SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.SdkValidation_error_sdk_with_name_and_version_exists, (Object)this.sdkElement.getAttribute("name"), (Object)this.sdkElement.getAttribute("version")));
        }
        if (status.isOK()) {
            status = new SdkBasePathValidator().validate(this.sdkElement.getAttribute("basePath"));
        }
        if (!status.isOK()) {
            throw new LoadSdkException(status);
        }
        this.basePath = this.sdkElement.getAttribute("basePath");
        if (this.sdkDescriptorPath != null && !this.sdkDescriptorPath.isEmpty()) {
            this.sdkElement.setAttribute("descriptorPath", this.sdkDescriptorPath);
        }
        if (this.isSdkLoadedByUser) {
            this.sdkElement.setAttribute("isLoadedByUser", "true");
        }
        String sdkName = this.sdkElement.getAttribute("name");
        String sdkVersion = this.sdkElement.getAttribute("version");
        this.sdkElement.setAttribute("basePath", this.getSdkBasePath());
        this.createEnviromment(sdkName, sdkVersion);
        this.createSuffixEnvironment();
    }

    private void createEnviromment(String sdkName, String sdkVersion) {
        String envName = SdkEnvironmentUtils.getEnviromnentName(sdkName, sdkVersion);
        SdkEnvironmentUtils.createEnvironment(envName, this.getSdkBasePath(), sdkName, false, true);
        NodeList envElements = this.sdkElement.getElementsByTagName("env");
        int i = 0;
        while (i < envElements.getLength()) {
            this.sdkElement.removeChild(envElements.item(i));
            ++i;
        }
        Element envElement = this.sdkElement.getOwnerDocument().createElement("env");
        envElement.setAttribute("name", envName);
        envElement.setAttribute("value", this.getSdkBasePath());
        envElement.setAttribute("isSystem", Boolean.FALSE.toString());
        this.sdkElement.appendChild(envElement);
    }

    private void createSuffixEnvironment() {
        Element variablesElement = this.getVariablesElement();
        if (variablesElement != null) {
            SdkEnvironmentUtils.createSdkSuffixEnvironment(this.getPathSuffixes(variablesElement), false, true);
        }
    }

    private Element getVariablesElement() {
        NodeList variablesNode = this.sdkElement.getElementsByTagName("variables");
        int i = 0;
        while (i < variablesNode.getLength()) {
            Element element = (Element)variablesNode.item(i);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private Map<String, String> getPathSuffixes(Element variablesElement) {
        HashMap<String, String> pathSuffix = new HashMap<String, String>();
        NodeList variableNodes = variablesElement.getElementsByTagName("variable");
        int i = 0;
        while (i < variableNodes.getLength()) {
            Element configElement = (Element)variableNodes.item(i);
            String name = configElement.getAttributes().getNamedItem("name").getNodeValue();
            String value = configElement.getAttributes().getNamedItem("value").getNodeValue();
            if (name != null && value != null) {
                pathSuffix.put(name, value);
            }
            ++i;
        }
        return pathSuffix;
    }

    private Collection<Element> performResourceTagsConversion(String sdkBasePath, Element toolChainElement) {
        Collection<Element> resourceElements = AbstractSdkDescriptorParser.getChildElements(toolChainElement, ResourceSdkKind.validValues().stream().map(ResourceSdkKind::getXmlElementName).collect(Collectors.toSet()).toArray(new String[0]));
        ArrayList<Element> convertedElements = new ArrayList<Element>();
        resourceElements.forEach(resourceElement -> {
            VariablesHelper.performSdkVariablesSubstitution(resourceElement, this.sdkVariables);
            convertedElements.addAll(AbstractResourceTagsConverter.convertResourceElement(resourceElement, toolChainElement, sdkBasePath));
        });
        return convertedElements;
    }

    private void parseEnvironment(Element holderElement) {
        AbstractSdkDescriptorParser.getChildElements(holderElement, "env").stream().findFirst().ifPresent(envElement -> VariablesHelper.performSdkVariablesSubstitution(envElement, this.sdkVariables));
    }

    private void createRootToolChain() {
        this.parseEnvironment(this.sdkElement);
        this.performResourceTagsConversion(this.basePath, this.sdkElement);
        this.parseToolChainChildElements(this.sdkElement, null);
        this.parseModules();
    }

    private void createToolChains() {
        for (Element toolChainElement : AbstractSdkDescriptorParser.getChildElements(this.sdkElement, "toolchain")) {
            VariablesHelper.performSdkVariablesSubstitution(toolChainElement, this.sdkVariables);
            this.performResourceTagsConversion(this.basePath, toolChainElement);
            this.parseToolChainChildElements(toolChainElement, toolChainElement.getAttribute("id"));
        }
    }

    private void parseToolChainChildElements(Element holderElement, String toolChainId) {
        SdkActionsHolder actionsHolder;
        ConditionGroupImpl conditionGroup = this.parseConditions(holderElement, toolChainId);
        if (conditionGroup != null) {
            this.conditionsGroups.add(conditionGroup);
        }
        if ((actionsHolder = this.parseActions(holderElement, toolChainId)) != null) {
            this.actionsHolders.add(actionsHolder);
        }
        this.parseSymbols(holderElement);
    }

    private void parseSymbols(Element holderElement) {
        AbstractSdkDescriptorParser.getChildElements(holderElement, "symbols").stream().flatMap(symbolsEl -> AbstractSdkDescriptorParser.getChildElements(symbolsEl, "symbol").stream()).forEach(symbolElement -> VariablesHelper.performSdkVariablesSubstitution(symbolElement, this.sdkVariables));
    }

    private void parseModules() {
        AbstractSdkDescriptorParser.getChildElements(this.sdkElement, "modules").stream().flatMap(modulesEl -> AbstractSdkDescriptorParser.getChildElements(modulesEl, "module").stream()).forEach(moduleElement -> VariablesHelper.performSdkVariablesSubstitution(moduleElement, this.sdkVariables));
    }

    private ConditionGroupImpl parseConditions(Element holderElement, String toolChainId) {
        Optional<Element> optional = AbstractSdkDescriptorParser.getChildElements(holderElement, "conditions").stream().findFirst();
        return optional.isPresent() ? new ConditionGroupImpl(optional.get(), this.sdkId, toolChainId) : ConditionGroupImpl.emptyGroup();
    }

    private SdkActionsHolder parseActions(Element holderElement, String toolChainId) {
        Optional<Element> optional = AbstractSdkDescriptorParser.getChildElements(holderElement, "actions").stream().findFirst();
        return optional.isPresent() ? new SdkActionsHolderImpl(optional.get(), this.sdkId, toolChainId, this.sdkVariables) : null;
    }

    private static Collection<Element> getChildElements(Element parentElement, String ... childElementNames) {
        ArrayList<Element> elements = new ArrayList<Element>();
        List<String> filterNames = Arrays.asList(childElementNames);
        NodeList nodeList = parentElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (filterNames.contains(node.getNodeName()) || filterNames.isEmpty()) {
                elements.add((Element)Element.class.cast(node));
            }
            ++i;
        }
        return elements;
    }

    private static enum ProgressCounter {
        TotalWork(100),
        ParseSDK(5),
        CreateSDK(75),
        RegisterGroupAndActions(20),
        RegisterDescriptor(80),
        ProcessedUnit(1);

        private final int value;

        private ProgressCounter(int work) {
            this.value = work;
        }

        public int getValue() {
            return this.value;
        }
    }
}

