/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariableScopes;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Variable {
    public static final String VARIABLE_ELEMENT = "variable";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VARIABLE_REFERENCE_PATTERN = "\\$\\[(.*?)\\]";
    private String name;
    private String value;
    private VariableScopes scope;

    public Variable(String name, String value) {
        this.name = Objects.requireNonNull(name);
        String aValue = Objects.requireNonNull(value);
        try {
            this.value = Objects.requireNonNull(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(aValue));
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to resolve variable", ce);
        }
    }

    public Variable(Element element, VariableScopes scope) {
        this.name = Objects.requireNonNull(element.getAttribute(NAME_ATTRIBUTE));
        String aValue = Objects.requireNonNull(element.getAttribute(VALUE_ATTRIBUTE));
        try {
            this.value = Objects.requireNonNull(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(aValue));
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to resolve variable", ce);
        }
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLocal() {
        return this.scope.isSdkLocal();
    }

    public boolean isGlobal() {
        return this.scope.isGlobal();
    }

    public void convertToXml(Document document, Element variablesElement) {
        Element variableElement = document.createElement(VARIABLE_ELEMENT);
        variableElement.setAttribute(NAME_ATTRIBUTE, this.getName());
        variableElement.setAttribute(VALUE_ATTRIBUTE, this.getValue());
        variablesElement.appendChild(variableElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

