/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.example.core.ExampleProjectFacade;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.ExamplesActivator;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExampleWorkspaceModifyOperation;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesSelectionPage;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.Messages;
import com.nxp.s32ds.ext.ide.core.refactoring.ISourceImporter;
import com.nxp.s32ds.ext.ide.core.refactoring.ImportOperation;
import com.nxp.s32ds.ext.ide.core.refactoring.RefactorContext;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.ui.refactoring.SourceImporter;
import com.nxp.s32ds.ext.rcp.datacollection.core.DataCollections;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class ExamplesWizard
extends Wizard
implements INewWizard {
    private ExamplesSelectionPage selectionPage;
    private boolean shouldShow;

    public ExamplesWizard() {
        this.setHelpAvailable(false);
    }

    public boolean isShouldShow() {
        return this.shouldShow;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean canFinish() {
        if (!this.selectionPage.validate().isOK()) {
            return false;
        }
        return this.selectionPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            RefactorContext ctx = new RefactorContext(this.selectionPage.getName(), this.selectionPage.getProjectSet());
            final ImportOperation io = new ImportOperation((ISourceImporter)new SourceImporter(), ctx);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List projectsPerfomed = io.perform(monitor);
                        ExampleWorkspaceModifyOperation exampleWorkspaceModifyOperation = new ExampleWorkspaceModifyOperation(projectsPerfomed);
                        exampleWorkspaceModifyOperation.run(monitor);
                        ExamplesWizard.this.sendEvent(monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            IStatus status = ExamplesActivator.getInstance().createError(DataTransferMessages.WizardExternalProjectImportPage_errorMessage, t);
            ExamplesActivator.getInstance().log(status);
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.shouldShow = true;
        final ExampleProjectFacade exampleFacade = new ExampleProjectFacade();
        IRunnableWithProgress initOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IStatus iStatus = exampleFacade.initExampleModel(monitor);
                if (!iStatus.isOK()) {
                    ExamplesActivator.getInstance().log(iStatus);
                }
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(true, true, initOperation);
            this.selectionPage = new ExamplesSelectionPage(exampleFacade);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            this.shouldShow = false;
            return;
        }
        this.setWindowTitle(Messages.Wizard_title);
    }

    private void sendEvent(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IExampleComponent component = this.selectionPage.getExampleComponent();
        if (component != null) {
            DataCollections.sendEventCollectExamples((String)component.getId(), (String)component.getProjectName(), (String)component.getFamilyId(), (String)component.getDeviceId(), (String)component.getCoreId());
        }
        subMonitor.done();
    }
}

