/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUnit {
    private static final String DYNAMIC_NAME_PATTERN = "\\@\\{[^\\}]+\\}";
    protected final boolean generate;
    protected String[] nameParts = new String[0];
    protected DynamicNamePart[] dynamicNameParts = new DynamicNamePart[0];
    private String[] templateIds;
    @Nullable
    public final String envVarName;
    @Nullable
    public final String simFileName;

    public FileUnit(String fileNamePattern, @Nullable String simFileName) {
        this(fileNamePattern, new String[0], false, "", simFileName);
    }

    private FileUnit(String fileNamePattern, String[] templateIds, boolean generate, @Nullable String envId, @Nullable String simFileName) {
        this.parseFileNamePattern(fileNamePattern);
        this.templateIds = (String[])templateIds.clone();
        this.generate = generate;
        this.envVarName = envId;
        this.simFileName = simFileName;
    }

    public FileUnit(String fileNamePattern, String[] templateIds, @Nullable String envId) {
        this(fileNamePattern, templateIds, true, envId, "");
    }

    public boolean containsScriptTemplate() {
        String[] stringArray = this.templateIds;
        int n = this.templateIds.length;
        int n2 = 0;
        while (n2 < n) {
            String templateId = stringArray[n2];
            if ("SCRIPT_TEMPLATE".equalsIgnoreCase(templateId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getFileName(ValidationContext vContext, CgenManager cgenManager) {
        StringBuilder buff = new StringBuilder();
        int dynIdx = 0;
        String[] stringArray = this.nameParts;
        int n = this.nameParts.length;
        int n2 = 0;
        while (n2 < n) {
            String namePart = stringArray[n2];
            if ("".equals(namePart)) {
                buff.append(cgenManager.getFileNamePart(vContext, this.dynamicNameParts[dynIdx++]));
            } else {
                buff.append(namePart);
            }
            ++n2;
        }
        return buff.toString();
    }

    public String[] getTemplateIds() {
        return (String[])this.templateIds.clone();
    }

    public boolean hasDynamicName() {
        return this.dynamicNameParts.length > 0;
    }

    private void parseFileNamePattern(String fileNamePattern) {
        ArrayList<String> txtList = new ArrayList<String>();
        ArrayList<@Nullable DynamicNamePart> dynList = new ArrayList<DynamicNamePart>();
        Pattern p = Pattern.compile(DYNAMIC_NAME_PATTERN);
        Matcher m = p.matcher(fileNamePattern);
        int startIdx = 0;
        while (m.find()) {
            if (m.start() > startIdx) {
                txtList.add(fileNamePattern.substring(startIdx, m.start()));
            }
            String dynType = m.group().substring(2, m.group().length() - 1);
            dynList.add(DynamicNamePart.getByPartName(dynType));
            txtList.add("");
            startIdx = m.end();
        }
        if (startIdx < fileNamePattern.length()) {
            txtList.add(fileNamePattern.substring(startIdx, fileNamePattern.length()));
        }
        this.nameParts = txtList.toArray(new String[txtList.size()]);
        this.dynamicNameParts = dynList.toArray(new DynamicNamePart[dynList.size()]);
    }

    public static enum DynamicNamePart {
        TEXT("NONE"),
        TABLE_ID("table"),
        ROW_ID("row"),
        COL_ID("col"),
        SCRIPT_ID("script"),
        ITERATION_ID("iteration");

        private final String partName;

        public static @Nullable DynamicNamePart getByPartName(String pName) {
            DynamicNamePart[] dynamicNamePartArray = DynamicNamePart.values();
            int n = dynamicNamePartArray.length;
            int n2 = 0;
            while (n2 < n) {
                DynamicNamePart value = dynamicNamePartArray[n2];
                if (value.partName.equalsIgnoreCase(pName)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        private DynamicNamePart(String _partName) {
            this.partName = _partName;
        }

        public String partName() {
            return this.partName;
        }
    }
}

