/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RunScriptRequest
implements Serializable {
    private static final long serialVersionUID = -6003555602791969445L;
    protected static final Logger LOGGER = LogManager.getLogger(RunScriptRequest.class);
    public static final String PARAMS_FOLDER_ENV_VAR_ID = "VALIDATION_SCRIPT_PARAMS_FOLDER";
    public static final String SCRIPT_INPUT_FILE_ENV_VAR_ID = "VALIDATION_SCRIPT_INPUT_PARAMS";
    public final String scriptId;
    public final ScriptFile[] files;
    public final long timeout;
    public final boolean partialResults;
    public final boolean independent;
    public final boolean immediate;
    public final Map<String, String> envVars;
    public final int ccsListeningPort;

    public RunScriptRequest(ScriptFile[] _files, String _scriptId, long _timeout, boolean _partialResults, boolean _immediate, boolean _independent, Map<String, String> _envVars, int _ccsListeningPort) {
        this.files = (ScriptFile[])_files.clone();
        this.scriptId = _scriptId;
        this.timeout = _timeout;
        this.partialResults = _partialResults;
        this.immediate = _immediate;
        this.independent = _independent;
        this.envVars = new HashMap<String, String>(_envVars);
        this.ccsListeningPort = _ccsListeningPort;
    }

    public static class ScriptFile
    implements Serializable {
        private static final long serialVersionUID = -6726537402740675895L;
        public final String name;
        public String content;
        public final boolean generate;
        @Nullable
        public final String envVarName;

        public ScriptFile(String name, String content, boolean generate, @Nullable String envVarName) {
            this.name = name;
            this.content = content;
            this.generate = generate;
            this.envVarName = envVarName;
        }

        public String getName() {
            return this.name;
        }

        public void writeFile(String logsFolder) {
            if (this.isBinary()) {
                try {
                    Throwable throwable = null;
                    Object var3_8 = null;
                    try (FileOutputStream outputStream = new FileOutputStream(String.valueOf(logsFolder) + File.separator + this.getName());){
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        DataOutputStream dos = new DataOutputStream(bos);
                        JSONObject jsonObject = new JSONObject(this.content);
                        JSONArray bytes = (JSONArray)jsonObject.get("bytes");
                        int i = 0;
                        while (i < bytes.length()) {
                            dos.writeInt(Integer.reverseBytes(bytes.getInt(i)));
                            ++i;
                        }
                        dos.flush();
                        byte[] memoryConfigData = bos.toByteArray();
                        ((OutputStream)outputStream).write(memoryConfigData);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | JSONException e) {
                    LOGGER.log(Level.SEVERE, Messages.RunScriptRequest_RunScriptRequest_UnableToGenerateFile, e.getMessage());
                }
            } else {
                try {
                    Throwable e = null;
                    Object var3_10 = null;
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(logsFolder) + File.separator + this.getName()), StandardCharsets.UTF_8));){
                        writer.write(this.content);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    LOGGER.warning(e.getMessage());
                }
            }
        }

        private boolean isBinary() {
            return this.name.endsWith(".bin");
        }
    }
}

