/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.actions;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.actions.GdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.actions.GdbPyStressTestAction;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.actions.SerialGdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.actions.SerialPyRunAction;
import com.nxp.swtools.mem.validation.connections.actions.SerialRunAction;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import java.io.IOException;

public class RunActionFactory {
    public static RunAction getRunAction(Connection connection, @Nullable VScenario vScenario) throws IOException, ResourceNotFoundException {
        switch (connection.getType()) {
            case CMSISDAP_CONNECTION: {
                if (vScenario != null && vScenario.isStressTest()) {
                    return new GdbPyStressTestAction();
                }
                return new GdbPyRunAction();
            }
            case SERIAL_OVER_GDB: 
            case S32PROBE_CONNECTION: {
                return new SerialGdbPyRunAction();
            }
            case SERIAL_CONNECTION: 
            case JTAG_CONNECTION: {
                return new SerialRunAction();
            }
            case S32SERIAL_CONNECTION: {
                return new SerialPyRunAction();
            }
        }
        throw new IllegalArgumentException(String.format(UtilsText.safeString((String)Messages.UnsupportedTargetAccessType), connection.getType().getName()));
    }
}

