/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.logging.Logger;

public class ProcessDestroyer {
    private static final Logger LOGGER = LogManager.getLogger(ProcessDestroyer.class);
    private static final String KILL_WINDOWS_PROCNAME = "taskkill /F /T /IM ";
    private static final String WINDOWS_PID_PARAMETER = " /PID ";
    private static final String KILL_WINDOWS_COMMAND = "taskkill /F /T";
    private static final String KILL_LINUX_PROCNAME = "pkill -9 ";
    private static final String KILL_LINUX_PID = "kill -9";
    private static final long PROCESS_DESTROY_TIMEOUT = 3000L;
    private static final long PROCESS_DESTROY_TIMEOUT_STEP = 200L;

    public static void destroy(String execName, @Nullable Process process, String @Nullable [] processesPID) {
        if (process != null) {
            if (!OSDetect.isWindows()) {
                process.destroy();
                long timeout = 0L;
                while (timeout <= 3000L) {
                    try {
                        timeout += 200L;
                        Thread.sleep(200L);
                        process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException | InterruptedException itse) {
                        LOGGER.severe(itse.getMessage());
                    }
                }
            }
            try {
                String killCommand;
                if (UtilsText.isArrayEmpty((String[])processesPID)) {
                    killCommand = String.valueOf(OSDetect.isUnix() ? KILL_LINUX_PROCNAME : KILL_WINDOWS_PROCNAME) + execName;
                } else {
                    String string = killCommand = OSDetect.isUnix() ? KILL_LINUX_PID : KILL_WINDOWS_COMMAND;
                    assert (processesPID != null);
                    String[] stringArray = processesPID;
                    int n = processesPID.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String pid = stringArray[n2];
                        killCommand = String.valueOf(killCommand) + (OSDetect.isUnix() ? " " + pid : WINDOWS_PID_PARAMETER + pid);
                        ++n2;
                    }
                }
                Process killProcess = Runtime.getRuntime().exec(killCommand);
                killProcess.waitFor();
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }
}

