/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.ui;

import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.SerialConnection;
import com.nxp.swtools.mem.validation.connections.TargetConnectionsSetting;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionParamView;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.connections.ui.Messages;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.io.File;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SerialConnectionParamView
extends ConnectionParamView {
    protected static final Logger LOGGER = LogManager.getLogger(SerialConnectionParamView.class);
    protected ConnectionView connView;
    private CCombo comPortCombo;
    private Button btnComPort;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private Label labelInfo;
    @Nullable
    private Button secureSerialCheckBtn;
    @Nullable
    private Button exportBtn;
    @Nullable
    protected Button browseBtn;
    @Nullable
    protected Text securedAppPath;
    private boolean hasProgressBar = false;
    private boolean hasSecuredSerialBoot = false;
    private static final int MAX_STEPS = 3;
    private static final int SCANNING_RESET = 0;
    private static final int SCANNING_START = 1;
    private static final int SCANNING_IN_PROGRESS = 2;
    private static final int SCANNING_END = 3;
    private static final int PRESERVE_STATE = -1;

    SerialConnectionParamView(ConnectionView connectionView, Composite parentView) {
        super(parentView);
        this.connView = connectionView;
        VModel vModel = ValidationContext.getInstance().getData().getModel();
        if (vModel != null) {
            String hasSerialSecuredOption;
            String comProgressBar = vModel.getCustomOption("com_port_progress_bar");
            if (comProgressBar != null) {
                this.hasProgressBar = Boolean.parseBoolean(comProgressBar);
            }
            if ((hasSerialSecuredOption = vModel.getCustomOption("serial_boot_secure_part")) != null) {
                this.hasSecuredSerialBoot = Boolean.parseBoolean(hasSerialSecuredOption);
            }
        }
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.hasSecuredSerialBoot) {
            this.createSecuredSerialView();
        }
        Group comGroup = new Group((Composite)this, 0);
        comGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        comGroup.setLayout((Layout)new GridLayout(2, true));
        Label comPortLabel = new Label((Composite)comGroup, 0);
        comPortLabel.setText(Messages.SelectComPortLabel);
        Composite portComposite = new Composite((Composite)comGroup, 0);
        portComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        portComposite.setLayout((Layout)new GridLayout(2, false));
        this.comPortCombo = new CCombo(portComposite, 2048);
        this.comPortCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.comPortCombo.setEditable(true);
        this.comPortCombo.addModifyListener(e -> this.updateUartComPort());
        this.btnComPort = new Button(portComposite, 8);
        this.btnComPort.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnComPort.setImage(Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/search_src.png"));
        this.btnComPort.setToolTipText(Messages.RefreshBtnTooltipMsg);
        this.btnComPort.setEnabled(true);
        this.btnComPort.addListener(13, e -> this.updateComPortCombo());
        if (this.hasProgressBar) {
            this.createProgressBar((Composite)comGroup);
        }
        this.updateComPortCombo();
        this.clockSourceLabel = new Label((Composite)comGroup, 0);
        this.clockSourceLabel.setText(Messages.ClockFrequency);
        this.clockComposite = new Composite((Composite)comGroup, 0);
        this.clockCompositeGridData = new GridData(4, 0x1000000, true, false);
        Composite clockCompositeLocal = Objects.requireNonNull(this.clockComposite);
        clockCompositeLocal.setLayoutData((Object)this.clockCompositeGridData);
        clockCompositeLocal.setLayout((Layout)new GridLayout(2, false));
        TargetConnectionsSetting targetConnections = this.connView.getTargetConnections();
        int minFreq = 20;
        int maxFreq = 40;
        int defaultFreq = 40;
        if (targetConnections != null) {
            minFreq = targetConnections.getMinClockFreq();
            maxFreq = targetConnections.getMaxClockFreq();
            defaultFreq = targetConnections.getDefaultClockFreq();
        }
        this.clockSourceSpinner = new Spinner(this.clockComposite, 2048);
        this.clockSourceSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Spinner clockSourceSpinnerLocal = Objects.requireNonNull(this.clockSourceSpinner);
        clockSourceSpinnerLocal.setMinimum(minFreq);
        clockSourceSpinnerLocal.setMaximum(maxFreq);
        clockSourceSpinnerLocal.setSelection(defaultFreq);
        this.mhzLabel = new Label(this.clockComposite, 0);
        this.mhzLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Objects.requireNonNull(this.mhzLabel).setText(Messages.MHzLabel);
        clockSourceSpinnerLocal.addListener(13, e -> this.updateClockSource());
        this.updateClockSource();
        Objects.requireNonNull(this.clockSourceLabel).setVisible(false);
        clockSourceSpinnerLocal.setVisible(false);
    }

    protected void createProgressBar(Composite parent) {
        Composite progressComposite = new Composite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        progressComposite.setLayoutData((Object)gridData);
        progressComposite.setLayout((Layout)new GridLayout(1, true));
        ProgressBar progressBarLoc = this.progressBar = new ProgressBar(progressComposite, 0);
        progressBarLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        progressBarLoc.setMaximum(3);
        Label labelInfoLoc = this.labelInfo = new Label(progressComposite, 0);
        labelInfoLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        labelInfoLoc.setText("");
    }

    protected void createSecuredSerialView() {
        Button secureSerialCheckBtnLoc = this.secureSerialCheckBtn = new Button((Composite)this, 32);
        GridData checkBtnGridData = new GridData();
        checkBtnGridData.horizontalSpan = 2;
        secureSerialCheckBtnLoc.setLayoutData((Object)checkBtnGridData);
        secureSerialCheckBtnLoc.setText(Messages.SecureSerialBootLabel);
        secureSerialCheckBtnLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SerialConnection serialConn = SerialConnectionParamView.this.getCurrentConnection();
                if (serialConn != null) {
                    GridData data;
                    Composite parent;
                    Button button = (Button)event.widget;
                    boolean selected = button.getSelection();
                    serialConn.setSecuredOptionCheckState(selected);
                    if (SerialConnectionParamView.this.securedAppPath != null) {
                        SerialConnectionParamView.this.securedAppPath.notifyListeners(24, new Event());
                    }
                    if (SerialConnectionParamView.this.browseBtn != null && (parent = SerialConnectionParamView.this.browseBtn.getParent()) != null && (data = (GridData)parent.getLayoutData()) != null) {
                        data.exclude = !selected;
                        parent.setVisible(selected);
                    }
                    if ((parent = SerialConnectionParamView.this.connView.getParent()) != null) {
                        ScrolledCompositeHelper.updateScrollSize((Composite)parent);
                        Composite grandParent = parent.getParent();
                        if (grandParent != null) {
                            grandParent.layout();
                        }
                    }
                }
            }
        });
        Composite securedSerialComp = new Composite((Composite)this, 2048);
        GridData browseCompdata = new GridData();
        browseCompdata.horizontalAlignment = 4;
        browseCompdata.verticalAlignment = 4;
        browseCompdata.grabExcessHorizontalSpace = true;
        browseCompdata.grabExcessVerticalSpace = true;
        browseCompdata.exclude = true;
        securedSerialComp.setLayoutData((Object)browseCompdata);
        securedSerialComp.setVisible(false);
        securedSerialComp.setLayout((Layout)new GridLayout(2, false));
        this.createExportOption(securedSerialComp);
        this.createBrowseOption(securedSerialComp);
    }

    protected void createExportOption(Composite parent) {
        final Button exportBtLoc = this.exportBtn = new Button(parent, 0);
        GridData exportData = new GridData(16384, 4, false, false);
        exportData.horizontalSpan = 2;
        exportData.widthHint = 160;
        exportBtLoc.setLayoutData((Object)exportData);
        exportBtLoc.setText(Messages.ExportButtonLabel);
        exportBtLoc.setToolTipText(Messages.ExportInfoTooltip);
        exportBtLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialConnection serialConn = SerialConnectionParamView.this.getCurrentConnection();
                if (serialConn != null) {
                    DirectoryDialog dialog = new DirectoryDialog(exportBtLoc.getShell(), 8192);
                    dialog.setText(Messages.DirectoryDialogText);
                    String directoryPath = dialog.open();
                    if (directoryPath != null) {
                        if (new File(directoryPath).isDirectory()) {
                            serialConn.setNonSecuredAppDir(directoryPath);
                            ValidationContext vContext = ValidationContext.getInstance();
                            CgenManager cgenManager = Activator.getDefault().getCgenManager();
                            ExecutionPresentationModel executionModel = SerialConnectionParamView.this.connView.getExecPresModel();
                            if (executionModel != null) {
                                VPresentationModel vPresModel = executionModel.getParent();
                                vContext.setData(vPresModel);
                                cgenManager.regenerate(false);
                            }
                        } else {
                            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (workbenchWindow != null) {
                                Shell shell = workbenchWindow.getShell();
                                MessageBox notifyUserBox = new MessageBox(shell, 65576);
                                notifyUserBox.setMessage(Messages.INVALID_DIRECTORY_MSG);
                                notifyUserBox.open();
                            }
                        }
                    }
                }
            }
        });
    }

    protected void createBrowseOption(Composite parent) {
        GridData exportBtnData;
        final Button browseBtnLoc = this.browseBtn = new Button(parent, 8);
        GridData browseData = new GridData(0x1000000, 4, false, false);
        if (this.exportBtn != null && (exportBtnData = (GridData)this.exportBtn.getLayoutData()) != null) {
            browseData.widthHint = exportBtnData.widthHint;
        }
        browseBtnLoc.setLayoutData((Object)browseData);
        browseBtnLoc.setText(Messages.BrowseSecuredApplicationLabel);
        browseBtnLoc.setToolTipText(Messages.BrowseBtnTooltip);
        browseBtnLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(browseBtnLoc.getShell(), 4096);
                String secureFilePath = dialog.open();
                if (SerialConnectionParamView.this.securedAppPath != null && secureFilePath != null) {
                    Text pathLoc = SerialConnectionParamView.this.securedAppPath;
                    pathLoc.setText(secureFilePath);
                    pathLoc.setSelection(pathLoc.getText().length());
                }
            }
        });
        final Text pathLoc = this.securedAppPath = new Text(parent, 2048);
        GridData pathData = new GridData();
        pathData.horizontalIndent = 3;
        pathData.horizontalAlignment = 4;
        pathData.verticalAlignment = 4;
        pathData.grabExcessHorizontalSpace = true;
        pathData.grabExcessVerticalSpace = true;
        pathLoc.setLayoutData((Object)pathData);
        final ControlDecoration ctrlDecorator = new ControlDecoration((Control)pathLoc, 16512);
        ctrlDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        ctrlDecorator.setDescriptionText(Messages.INVALID_FILE_PATH_OR_EXTENSION);
        pathLoc.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
        pathLoc.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SerialConnection serialConn = SerialConnectionParamView.this.getCurrentConnection();
                if (serialConn != null) {
                    Text text = (Text)event.widget;
                    String fullPath = text.getText();
                    File pathFile = new File(fullPath);
                    if (pathFile.exists() && fullPath.endsWith(".bin")) {
                        serialConn.setSecuredAppPath(fullPath);
                        text.setBackground(null);
                        ctrlDecorator.hide();
                    } else {
                        serialConn.setSecuredAppPath("");
                        text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
                        ctrlDecorator.show();
                    }
                    pathLoc.setToolTipText(fullPath);
                    SerialConnectionParamView.this.connView.setConnectionInModel();
                }
            }
        });
    }

    protected void updateUartComPort() {
        SerialConnection serialConnection = this.getCurrentConnection();
        if (serialConnection != null) {
            String currentPort = this.comPortCombo.getText();
            serialConnection.setComPort(currentPort == null || currentPort.equals(Messages.UNDEFINED_PORT_NAME) ? "" : currentPort);
            this.connView.setConnectionInModel();
        }
    }

    protected void updateClockSource() {
        SerialConnection serialConnection = this.getCurrentConnection();
        if (serialConnection != null && this.clockSourceSpinner != null) {
            serialConnection.setClockSource(this.clockSourceSpinner.getSelection());
        }
    }

    protected void updateComPortCombo() {
        SerialConnection serialConnection = this.getCurrentConnection();
        if (serialConnection != null) {
            String currentPort = serialConnection.getComPort();
            this.comPortCombo.removeAll();
            this.updateProgress(Messages.COM_PORTS_SCAN_MESSAGE, 0, 0);
            this.updateProgress(null, 1, -1);
            this.comPortCombo.setItems(SerialConnection.getCOMPorts());
            this.updateProgress(null, 2, -1);
            int currentPortIdx = -1;
            if (!currentPort.isEmpty()) {
                currentPortIdx = this.comPortCombo.indexOf(currentPort);
            }
            if (currentPortIdx < 0) {
                if (this.comPortCombo.getItemCount() > 0) {
                    this.comPortCombo.select(0);
                    String currentPortName = this.comPortCombo.getText();
                    if (currentPortName == null || currentPortName.isEmpty()) {
                        LOGGER.severe("Connection UI creation error - each port should have a name!");
                        this.updateProgress(Messages.PORT_NAME_NOT_FOUND, 3, 1);
                        return;
                    }
                    if (currentPortName.equals(Messages.UNDEFINED_PORT_NAME)) {
                        serialConnection.setComPort("");
                        this.updateProgress(Messages.COM_PORT_NOT_FOUND, 3, 4);
                    } else {
                        serialConnection.setComPort(currentPortName);
                        this.updateProgress(Messages.SCANNING_COMPLETE, 3, -1);
                    }
                } else {
                    serialConnection.setComPort("");
                    this.updateProgress(Messages.COM_PORT_NOT_FOUND, 3, 4);
                }
            } else {
                this.comPortCombo.select(currentPortIdx);
                String currentPortName = this.comPortCombo.getText();
                if (currentPortName != null && currentPortName.equals(Messages.UNDEFINED_PORT_NAME)) {
                    this.updateProgress(Messages.COM_PORT_NOT_FOUND, 3, 4);
                } else {
                    this.updateProgress(Messages.SCANNING_COMPLETE, 3, -1);
                }
            }
        } else {
            this.comPortCombo.select(0);
        }
    }

    private void updateProgress(@Nullable String label, int selection, int state) {
        if (this.hasProgressBar) {
            if (this.progressBar != null) {
                ProgressBar progressBarLoc = this.progressBar;
                progressBarLoc.setSelection(selection);
                if (state != -1) {
                    progressBarLoc.setState(state);
                }
            }
            if (this.labelInfo != null && label != null) {
                this.labelInfo.setText(label);
            }
        }
    }

    protected @Nullable SerialConnection getCurrentConnection() {
        String currentConnection = this.connView.getConnectionCombo().getText();
        if (currentConnection == null || currentConnection.isEmpty()) {
            return null;
        }
        Object data = this.connView.getConnectionCombo().getData(currentConnection);
        if (!(data instanceof SerialConnection)) {
            LOGGER.severe("Connection UI creation error - current connection should be of type SERIALConnection at this point.");
            return null;
        }
        return (SerialConnection)data;
    }

    public void setEnabled(boolean enabled) {
        this.comPortCombo.setEnabled(enabled);
        this.btnComPort.setEnabled(enabled);
        if (this.secureSerialCheckBtn != null) {
            this.secureSerialCheckBtn.setEnabled(enabled);
        }
        if (this.browseBtn != null) {
            this.browseBtn.setEnabled(enabled);
        }
        if (this.securedAppPath != null) {
            this.securedAppPath.setEnabled(enabled);
        }
        if (this.exportBtn != null) {
            this.exportBtn.setEnabled(enabled);
        }
        if (this.clockSourceSpinner != null) {
            this.clockSourceSpinner.setEnabled(enabled);
        }
    }

    public void dispose() {
        super.dispose();
        this.comPortCombo.dispose();
        this.btnComPort.dispose();
        if (this.clockSourceSpinner != null) {
            this.clockSourceSpinner.dispose();
        }
        if (this.clockSourceLabel != null) {
            this.clockSourceLabel.dispose();
        }
        if (this.progressBar != null) {
            this.progressBar.dispose();
        }
        if (this.labelInfo != null) {
            this.labelInfo.dispose();
        }
        if (this.secureSerialCheckBtn != null) {
            this.secureSerialCheckBtn.dispose();
        }
        if (this.browseBtn != null) {
            this.browseBtn.dispose();
        }
        if (this.securedAppPath != null) {
            this.securedAppPath.dispose();
        }
        if (this.exportBtn != null) {
            this.exportBtn.dispose();
        }
    }
}

