/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptFileParamValue;
import com.nxp.swtools.mem.validation.ui.CustomText;
import com.nxp.swtools.mem.validation.ui.FileParamView;
import com.nxp.swtools.mem.validation.ui.VScriptParamsView;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.io.File;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class FilePathParamListener
implements ModifyListener {
    VPresentationModel data;

    public FilePathParamListener(VPresentationModel data) {
        this.data = data;
    }

    static void setFileSize(Control sizeBox, File pathFile) {
        if (sizeBox instanceof CustomText) {
            long valueInMultiplier;
            CustomText customText = (CustomText)sizeBox;
            long fileSize = pathFile.length();
            String multiplier = null;
            if (fileSize > 0x40000000L) {
                valueInMultiplier = fileSize / 0x40000000L;
                multiplier = Messages.UnitGB;
            } else if (fileSize > 0x100000L) {
                valueInMultiplier = fileSize / 0x100000L;
                multiplier = Messages.UnitMB;
            } else {
                valueInMultiplier = fileSize / 1024L;
                if (valueInMultiplier == 0L && fileSize > 0L) {
                    valueInMultiplier = 1L;
                }
                multiplier = Messages.UnitKB;
            }
            customText.switchState(multiplier);
            customText.setText(String.valueOf(valueInMultiplier));
        }
    }

    public void modifyText(ModifyEvent event) {
        FileParamView fileView;
        Object fileViewData;
        Composite textGrandParent;
        Text text = (Text)event.widget;
        String fullPath = text.getText();
        File pathFile = new File(fullPath);
        Object textData = text.getData("qcs.validation.ddr.widget.decorator");
        Composite textParent = text.getParent();
        if (textParent != null && (textGrandParent = textParent.getParent()) instanceof FileParamView && (fileViewData = (fileView = (FileParamView)textGrandParent).getData("qcs.validation.ddr.model")) instanceof VScriptFileParamValue && textData instanceof ControlDecoration) {
            VScriptConfig selScriptConfig;
            VScriptFileParamValue model = (VScriptFileParamValue)fileViewData;
            ControlDecoration ctrlDecorator = (ControlDecoration)textData;
            ValidationPresentationModel validation = this.data.getValidationModel();
            VScriptParamsView paramView = this.data.getParamView();
            if (validation != null && paramView != null && (selScriptConfig = this.data.getSelectedScriptConfig()) != null) {
                String paramName = model.getParam().getName();
                Control sizeBox = paramView.getControlByParamId("app.test_params.size");
                if (sizeBox != null) {
                    if (model.isEnabled()) {
                        if (pathFile.exists()) {
                            model.setPath(fullPath);
                            text.setBackground(null);
                            ctrlDecorator.hide();
                            validation.removeInvalidScriptConfig(selScriptConfig, paramName);
                            FilePathParamListener.setFileSize(sizeBox, pathFile);
                        } else {
                            model.setPath("");
                            text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
                            ctrlDecorator.show();
                            validation.addInvalidScriptConfig(selScriptConfig, paramName);
                        }
                    } else {
                        ctrlDecorator.hide();
                        text.setBackground(null);
                        validation.removeInvalidScriptConfig(selScriptConfig, paramName);
                    }
                    this.data.validateSelectedScriptConfig();
                }
            }
        }
    }
}

