/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.presenter.updaters.ScenarioOptionsUiUpdater;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ScriptConfigSelectionListener
extends SelectionAdapter {
    private VPresentationModel data;

    private static int getNumberCheckedItems(Table table) {
        int numSel = 0;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                ++numSel;
            }
            ++n2;
        }
        return numSel;
    }

    public ScriptConfigSelectionListener(VPresentationModel data) {
        this.data = data;
    }

    private void updateScriptConfigCheckedState(SelectionEvent e) {
        assert (e.item instanceof TableItem) : Messages.ScriptConfigSelectionListener_NotATableItem;
        assert (e.item.getData() instanceof VScriptConfig) : Messages.ScriptConfigSelectionListener_NotAVScriptConfig;
        ValidationPresentationModel vData = this.data.getValidationModel();
        if (vData != null && vData.isChangedEnabled()) {
            TableItem tableItem = (TableItem)e.item;
            VScriptConfig scriptConfig = (VScriptConfig)tableItem.getData();
            int numSelected = ScriptConfigSelectionListener.getNumberCheckedItems(tableItem.getParent());
            if (!tableItem.getChecked() && numSelected == 0) {
                e.doit = false;
                tableItem.setChecked(true);
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    Shell shell = workbenchWindow.getShell();
                    MessageBox notifyUserBox = new MessageBox(shell, 65576);
                    notifyUserBox.setText(Messages.ScriptConfigSelectionListener_WarningText);
                    notifyUserBox.setMessage(Messages.ScriptConfigSelectionListener_WarningMessage);
                    notifyUserBox.open();
                }
            } else {
                VStagePresentation stage = this.data.getSelectedStage();
                if (stage != null && scriptConfig != null) {
                    stage.updateScriptConfig(scriptConfig, tableItem.getChecked());
                }
            }
        }
        this.data.updateUI(new ScenarioOptionsUiUpdater(this.data), JobName.UPDATE_MODEL_ON_SCRIPT_SELECTION_CHANGE.name);
        ExecutionPresentationModel executionLoc = this.data.getExecution();
        if (executionLoc != null) {
            this.data.updateExecutionPresentationModel(false);
            this.data.getView().getExecutionView().setInput(executionLoc);
        }
    }

    private void updateScriptConfigSelectState(SelectionEvent e) {
        VStagePresentation vStage;
        VScenarioPresentation scenario = this.data.getSelectedScenario();
        if (scenario != null && scenario.isScriptConfigAutoSelected()) {
            scenario.setScriptConfigAutoSelected(false);
            return;
        }
        VStagePresentation stage = this.data.getSelectedStage();
        if (stage != null && stage.isCountEditing()) {
            return;
        }
        Table table = (Table)e.getSource();
        TableItem[] selections = table.getSelection();
        if (selections == null || selections.length == 0) {
            return;
        }
        VScriptConfig sc = (VScriptConfig)selections[0].getData();
        ValidationPresentationModel vModel = this.data.getValidationModel();
        if (vModel != null && (vStage = vModel.getSelectedStage()) != null && sc != null) {
            MainView mView;
            VScenarioOptionsView sView;
            VScenarioPresentation vscenario = vStage.getSelectedScenario();
            if (vscenario != null) {
                vscenario.setSelectedScriptConfig(sc);
            }
            if ((sView = (mView = this.data.getView()).getScenarioOptionsView()) != null) {
                sView.updateTestConfigurationUI(sc);
                this.data.validateSelectedScriptConfig();
            }
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event == null) {
            return;
        }
        VStagePresentation stage = this.data.getSelectedStage();
        if (stage == null) {
            return;
        }
        if (stage.isCountEditing()) {
            return;
        }
        if (event.detail == 32) {
            this.updateScriptConfigCheckedState(event);
            if (((TableItem)event.item).getChecked() && stage.getSyncScriptConfig()) {
                stage.syncAllParams(true, this.data);
                this.data.validateSelectedScriptConfig();
            }
        } else {
            this.data.setSkipSync(true);
            this.updateScriptConfigSelectState(event);
            this.data.setSkipSync(false);
        }
    }
}

