/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.presenter.updaters.RefreshUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.util.Objects;
import org.eclipse.swt.graphics.Point;

public class CABusEyeResultHandler
extends ARunResultsUpdaterListener {
    private static final String EYE_STAGE_NAME = "vTSA";
    private VPresentationModel model;
    @Nullable
    private VStage stage;
    @Nullable
    private VScenario scenario;
    private VLoggingUtils.ScriptResultType resultType = VLoggingUtils.ScriptResultType.PASSED;
    @Nullable
    private String output;

    public CABusEyeResultHandler(VPresentationModel presentationModel) {
        VStagePresentation stagePresentation;
        this.model = presentationModel;
        ValidationPresentationModel validationModel = this.model.getValidationModel();
        if (validationModel != null && (stagePresentation = validationModel.getStage(Objects.requireNonNull(EYE_STAGE_NAME))) != null) {
            this.stage = stagePresentation.getModel();
        }
    }

    @Override
    public IValidationSessionEventListener.VEventListenerResult onEvent(VSessionModel session, VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        if (phase == VSessionModel.VEventPhase.VSCENARIO_END) {
            return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
        }
        if (phase == VSessionModel.VEventPhase.SCRIPT_END) {
            this.scenario = event.scenario;
            this.updateModel();
            this.model.updateUI(new RefreshUIRunnable(this.model, RefreshUIRunnable.RefreshMode.SELECT_SCENARIO, true), JobName.REFRESH_UI_ON_NEW_TEST_RESULTS.name);
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    @Override
    public @Nullable VSessionModel.VEvent getNextEvent() {
        return null;
    }

    @Override
    public double getProgress() {
        return 0.0;
    }

    @Override
    public @Nullable VScenario getScenario() {
        return null;
    }

    @Override
    public @Nullable VStage getStage() {
        return null;
    }

    @Override
    public @Nullable VTable getTable() {
        return null;
    }

    @Override
    public VTable[] getTables() {
        return new VTable[0];
    }

    @Override
    public void setRawOutput(String output) {
        this.output = output;
    }

    @Override
    public void setFailureType(VLoggingUtils.ScriptResultType resultType) {
        this.resultType = resultType;
    }

    @Override
    public void setResultText(String resultText) {
    }

    private void updateModel() {
        VRunResult[] results;
        VTableGroup tableGrp;
        VTable[] allTables;
        VTable crtTable;
        VParamVariation crtCell;
        VTableGroup[] tableGroup;
        if (this.stage != null && this.scenario != null && (tableGroup = this.scenario.getTableGroups()) != null && (crtCell = (crtTable = (allTables = (tableGrp = tableGroup[0]).getTables())[0]).getParamVariation(new Point(0, 0))) != null && (results = crtCell.getResults()) != null && results.length > 0) {
            VRunResult runResult = results[0];
            runResult.setType(this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED) ? VRunResult.ResultType.PASSED : VRunResult.ResultType.FAILED);
            runResult.setFailureType(this.resultType);
            runResult.setErrorMessage(this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED) ? "" : VLoggingUtils.extractErrorMessage(UtilsText.safeString((String)this.output)));
            this.model.onValidationRunResults(Objects.requireNonNull(this.stage), Objects.requireNonNull(this.scenario), runResult);
        }
    }
}

