/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.Messages;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.presenter.updaters.RefreshUIRunnable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ExecutionPresentationModel {
    @Nullable
    private ISettingConfig diagsRestrictionSetting;
    private static String DIAGS_SCENARIO_RESTRICTION_SETTING_ID = "diags_scenario_validation_restriction";
    private VPresentationModel parent;
    private ExecutionData data;

    protected void setDiagsScenarioValidationRestrictionSetting(ISettingConfig setting) {
        this.diagsRestrictionSetting = setting;
    }

    public ExecutionPresentationModel(VPresentationModel _parent) {
        this.parent = _parent;
        this.data = new ExecutionData();
        this.parseValidationRestrictions();
    }

    private void parseValidationRestrictions() {
        IComponentInstanceConfig componentInstanceConfig;
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null && (componentInstanceConfig = configController.getInstance(configController.getCurrentInstanceName())) != null) {
            Map configSets = componentInstanceConfig.getConfigSets();
            configSets.entrySet().stream().findFirst().ifPresent(configSet -> ((IConfigSetConfig)configSet.getValue()).getChildren().stream().filter(setting -> UtilsText.safeString((String)setting.getId()).contains(DIAGS_SCENARIO_RESTRICTION_SETTING_ID)).findAny().ifPresent(this::setDiagsScenarioValidationRestrictionSetting));
        }
    }

    public VPresentationModel getParent() {
        return this.parent;
    }

    public ExecutionData getData() {
        return this.data;
    }

    public String getStartDecoratorTooltip() {
        return this.data.startDecTooltip;
    }

    public DecoratorType getStartDecoratorType() {
        return this.data.startDecType;
    }

    public StartValidationMode getStartMode() {
        return this.data.startMode;
    }

    public boolean hasStageInProgress() {
        return this.data.startMode != StartValidationMode.VALIDATE;
    }

    public boolean isStartEnabled() {
        return this.areRestrictionsRespected() && this.data.enableStart;
    }

    private boolean areRestrictionsRespected() {
        boolean restrictionsRespected = this.checkForValidationRestrictions();
        if (!restrictionsRespected) {
            this.updateStartDecorator(DecoratorType.ERROR, Messages.ExecutionPresentationModel_InvalidScenarioSelected_TooltipText);
        }
        return restrictionsRespected;
    }

    public void resetUiData(boolean _enableStartButton) {
        this.data.startMode = StartValidationMode.VALIDATE;
        this.setStartEnabled(_enableStartButton);
    }

    private boolean checkForValidationRestrictions() {
        VStagePresentation selectedStage;
        ISettingConfig validationEnabledSettingLoc = this.diagsRestrictionSetting;
        boolean diagsRestrictionPresentInDataModel = validationEnabledSettingLoc != null && "true".equalsIgnoreCase(UtilsText.safeString((String)validationEnabledSettingLoc.getValue().toString()));
        ValidationPresentationModel validationPresentationModel = this.parent.getValidationModel();
        boolean invalidScenarioSelected = false;
        if (validationPresentationModel != null && (selectedStage = validationPresentationModel.getSelectedStage()) != null) {
            String selectedStageName = selectedStage.getName();
            List<VScenario> selStageScenarios = Arrays.asList(selectedStage.getModel().getScenarios());
            if (diagsRestrictionPresentInDataModel && VStage.StageType.DIAGS.getName().equals(selectedStageName)) {
                invalidScenarioSelected = selStageScenarios.stream().anyMatch(scenario -> this.isSelectedScenario((IScenarioElement)scenario));
            }
        }
        return !invalidScenarioSelected;
    }

    private boolean isSelectedScenario(IScenarioElement scenario) {
        boolean scenarioSelected = scenario.isSelected();
        List<IScenarioElement> children = Arrays.asList(scenario.getChildren());
        for (IScenarioElement child : children) {
            if (!this.isSelectedScenario(child)) continue;
            scenarioSelected |= true;
            break;
        }
        return scenarioSelected;
    }

    public void setStartEnabled(boolean _enableStartButton) {
        this.data.enableStart = _enableStartButton && this.areRestrictionsRespected();
    }

    public void setStartMode(StartValidationMode _startMode) {
        this.data.startMode = _startMode;
    }

    public void setConnection(@Nullable Connection connection) {
        this.data.setConnection(connection);
        this.parent.updateExecutionPresentationModel(false);
        this.parent.updateUI(new RefreshUIRunnable(this.parent, RefreshUIRunnable.RefreshMode.SV_BUTTON_STATE, false), UtilsText.safeString((String)"Set Connection..."));
    }

    public @Nullable Connection getConnection() {
        return this.data.getConnection();
    }

    public boolean hasConnectionErrors() {
        Connection connection = this.data.getConnection();
        return connection == null || connection.hasErrors();
    }

    public String getConnectionErrors() {
        Connection connection = this.data.getConnection();
        if (connection == null) {
            return Messages.ERR_NO_CONNECTION_MSG;
        }
        return connection.getErrorMessage();
    }

    public void updateStartDecorator(DecoratorType decType, String decTooltip) {
        this.data.startDecType = decType;
        this.data.startDecTooltip = decTooltip;
    }

    public void setSkipDownload(boolean skipDownload) {
        this.data.skipDownload = skipDownload;
    }

    public boolean getSkipDownload() {
        return this.data.skipDownload;
    }

    public void setTestTimeout(long testTimeout) {
        this.data.testTimeout = testTimeout;
    }

    public long getTestTimeout() {
        return this.data.testTimeout;
    }

    public void setIgnoreTimeout(boolean ignoreTimeout) {
        this.data.ignoreTimeout = ignoreTimeout;
    }

    public boolean ignoreTimeout() {
        return this.data.ignoreTimeout;
    }

    public static enum DecoratorType {
        ERROR,
        WARNING,
        INFO,
        NONE;

    }

    public static class ExecutionData {
        @Nullable
        protected Connection connection;
        protected StartValidationMode startMode = StartValidationMode.VALIDATE;
        protected boolean enableStart = false;
        protected DecoratorType startDecType = DecoratorType.NONE;
        protected String startDecTooltip = "";
        protected boolean skipDownload = false;
        protected long testTimeout = -1L;
        protected boolean ignoreTimeout = true;

        protected void setConnection(@Nullable Connection _connection) {
            this.connection = _connection;
        }

        protected @Nullable Connection getConnection() {
            return this.connection;
        }
    }

    public static enum StartValidationMode {
        VALIDATE,
        CANCEL,
        NEXT_STEP,
        WAIT_SYNC;

    }
}

