/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scripts;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.ParserUtility;
import com.nxp.swtools.mem.validation.model.scripts.AddressRange;
import com.nxp.swtools.mem.validation.model.scripts.DefaultVScript;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VScriptParser {
    private static final Logger LOGGER = LogManager.getLogger(VScriptParser.class);
    public static final String TAG_SCRIPTS = "test-scripts";
    public static final String TAG_SCRIPT = "test-script";
    public static final String TAG_ID = "id";
    public static final String TAG_NAME = "name";
    public static final String TAG_TEMPLATES = "templates";
    public static final String TAG_TEMPLATE = "template";
    public static final String TAG_FILE = "file";
    public static final String TAG_CONDITION = "condition";
    public static final String TAG_SPECIFIC_TEST = "specific-test";
    public static final String TAG_TEST_DESCRIPTION = "description";
    public static final String TAG_PARAMETERS = "parameters";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_TYPE = "type";
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_HIDDEN = "hidden";
    public static final String TAG_DEFAULT_VALUE = "default-value";
    public static final String TAG_OPTIONS = "options";
    public static final String TAG_OPTION = "option";
    public static final String TAG_VALUE = "value";
    public static final String TAG_DEFAULT_TESTS = "default-tests";
    public static final String TAG_DEFAULT_SCRIPT = "default-test";
    public static final String TAG_TEST_ID = "test-id";
    public static final String TAG_CONDITION_ID = "condition-id";
    public static final String TAG_COUNT = "count";
    public static final String TAG_MIN_SIZE = "min-size";
    public static final String TAG_CUSTOM_SIZE_UNIT = "custom-size-unit";
    public static final String TAG_AVAILABLE_MEMORY_ID = "available-memory-id";
    public static final String TAG_MIN_START_ADDRESS = "min-start-address";
    static String scriptDirPath = ".";

    private static DefaultVScript parseDefaultScript(Node node) throws Exception {
        String scriptId = null;
        int count = 0;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = Objects.requireNonNull(childNodes.item(i));
            if (TAG_TEST_ID.equalsIgnoreCase(childNode.getNodeName())) {
                scriptId = ParserUtility.getNodeTextContent(childNode);
            } else if (TAG_COUNT.equalsIgnoreCase(childNode.getNodeName())) {
                count = Integer.parseInt(ParserUtility.getNodeTextContent(childNode));
            }
            ++i;
        }
        if (scriptId == null || count <= 0) {
            throw new Exception(Messages.VScriptParser_0);
        }
        return new DefaultVScript(scriptId, count);
    }

    private static List<DefaultVScript> parseDefaultScripts(Node node) throws Exception {
        ArrayList<DefaultVScript> defaultScripts = new ArrayList<DefaultVScript>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = Objects.requireNonNull(childNodes.item(i));
            if (TAG_DEFAULT_SCRIPT.equalsIgnoreCase(childNode.getNodeName())) {
                defaultScripts.add(VScriptParser.parseDefaultScript(childNode));
            }
            ++i;
        }
        return defaultScripts;
    }

    private static VScript parseScript(Node node) throws Exception {
        NodeList childNodes = node.getChildNodes();
        String id = null;
        String name = null;
        String testDescription = "";
        boolean specificTest = false;
        VScriptParam[] params = new VScriptParam[]{};
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = Objects.requireNonNull(childNodes.item(i));
            if (TAG_ID.equalsIgnoreCase(childNode.getNodeName())) {
                id = ParserUtility.getNodeTextContent(childNode);
            } else if (TAG_NAME.equalsIgnoreCase(childNode.getNodeName())) {
                name = ParserUtility.getNodeTextContent(childNode);
            } else {
                if (TAG_SPECIFIC_TEST.equalsIgnoreCase(childNode.getNodeName())) {
                    String specificTestStr = ParserUtility.getNodeTextContent(childNode);
                    specificTest = Boolean.valueOf(specificTestStr);
                }
                if ("description".equalsIgnoreCase(childNode.getNodeName())) {
                    testDescription = ParserUtility.getNodeTextContent(childNode);
                } else if (TAG_PARAMETERS.equalsIgnoreCase(childNode.getNodeName())) {
                    params = VScriptParser.parseScriptParams(childNode.getChildNodes());
                }
            }
            ++i;
        }
        if (id == null || name == null) {
            throw new Exception(Messages.VScriptParser_1);
        }
        return new VScript(id, name, specificTest, testDescription, params, false);
    }

    private static VScriptParam parseScriptParam(Node node) throws Exception {
        String id = null;
        VScriptParam.VScriptParamType type = null;
        String name = null;
        String description = "";
        String defaultValue = null;
        VScriptParam.Options options = null;
        long minSize = 1L;
        boolean hidden = false;
        String customSizeUnit = null;
        String availableMemoryId = null;
        AddressRange minStartAddress = null;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = Objects.requireNonNull(childNodes.item(i));
            if (TAG_ID.equalsIgnoreCase(childNode.getNodeName())) {
                id = ParserUtility.getNodeTextContent(childNode);
            } else if (TAG_TYPE.equalsIgnoreCase(childNode.getNodeName())) {
                String strType = ParserUtility.getNodeTextContent(childNode);
                type = VScriptParam.VScriptParamType.valueOf(strType);
            } else if (TAG_NAME.equalsIgnoreCase(childNode.getNodeName())) {
                name = ParserUtility.getNodeTextContent(childNode);
            } else if ("description".equalsIgnoreCase(childNode.getNodeName())) {
                description = ParserUtility.getNodeTextContent(childNode);
            } else if (TAG_HIDDEN.equalsIgnoreCase(childNode.getNodeName())) {
                String hiddenStr = ParserUtility.getNodeTextContent(childNode);
                hidden = Boolean.valueOf(hiddenStr);
            } else if (TAG_DEFAULT_VALUE.equalsIgnoreCase(childNode.getNodeName())) {
                defaultValue = ParserUtility.getNodeTextContent(childNode);
            } else if (TAG_OPTIONS.equalsIgnoreCase(childNode.getNodeName())) {
                options = VScriptParser.parseScriptParamOptions(childNode);
            } else {
                if (TAG_MIN_SIZE.equalsIgnoreCase(childNode.getNodeName())) {
                    String minSizeStr = ParserUtility.getNodeTextContent(childNode);
                    minSize = Long.valueOf(minSizeStr);
                }
                if (TAG_CUSTOM_SIZE_UNIT.equalsIgnoreCase(childNode.getNodeName())) {
                    customSizeUnit = ParserUtility.getNodeTextContent(childNode);
                }
                if (TAG_AVAILABLE_MEMORY_ID.equalsIgnoreCase(childNode.getNodeName())) {
                    availableMemoryId = ParserUtility.getNodeTextContent(childNode);
                }
                if (TAG_MIN_START_ADDRESS.equalsIgnoreCase(childNode.getNodeName())) {
                    minStartAddress = new AddressRange(ParserUtility.getNodeTextContent(childNode));
                }
            }
            ++i;
        }
        if (id == null || type == null || name == null || defaultValue == null) {
            throw new Exception(Messages.VScriptParser_2);
        }
        return new VScriptParam(id, type, name, description, defaultValue, hidden, options, minSize, customSizeUnit, availableMemoryId, minStartAddress);
    }

    private static VScriptParam.Options parseScriptParamOptions(Node node) throws Exception {
        ArrayList<VScriptParam.Option> optionList = new ArrayList<VScriptParam.Option>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = Objects.requireNonNull(childNodes.item(i));
            if (TAG_OPTION.equalsIgnoreCase(childNode.getNodeName())) {
                NodeList optionNodes = childNode.getChildNodes();
                String name = null;
                String value = null;
                int j = 0;
                while (j < optionNodes.getLength()) {
                    Node optionNode = Objects.requireNonNull(optionNodes.item(j));
                    if (TAG_NAME.equalsIgnoreCase(optionNode.getNodeName())) {
                        name = ParserUtility.getNodeTextContent(optionNode);
                    } else if (TAG_VALUE.equalsIgnoreCase(optionNode.getNodeName())) {
                        value = ParserUtility.getNodeTextContent(optionNode);
                    }
                    ++j;
                }
                assert (name != null && value != null);
                optionList.add(new VScriptParam.Option(name, value));
            }
            ++i;
        }
        return new VScriptParam.Options(optionList.toArray(new VScriptParam.Option[optionList.size()]));
    }

    private static VScriptParam[] parseScriptParams(NodeList nodes) throws Exception {
        ArrayList<VScriptParam> paramList = new ArrayList<VScriptParam>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = Objects.requireNonNull(nodes.item(i));
            if (TAG_PARAMETER.equalsIgnoreCase(childNode.getNodeName())) {
                VScriptParam param = VScriptParser.parseScriptParam(childNode);
                assert (param != null) : Messages.VScriptParser_3;
                paramList.add(param);
            }
            ++i;
        }
        return paramList.toArray(new VScriptParam[paramList.size()]);
    }

    public static @Nullable Scripts parseScripts(String configFile, String _scriptDirPath) {
        scriptDirPath = _scriptDirPath;
        ArrayList<VScript> scriptList = new ArrayList<VScript>();
        List<DefaultVScript> defaultScriptList = new ArrayList<DefaultVScript>();
        try {
            Node rootNode = ParserUtility.extractRootXmlNode(configFile);
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = Objects.requireNonNull(childNodes.item(i));
                if (TAG_SCRIPT.equalsIgnoreCase(childNode.getNodeName())) {
                    VScript script = VScriptParser.parseScript(childNode);
                    scriptList.add(script);
                } else if (TAG_DEFAULT_TESTS.equalsIgnoreCase(childNode.getNodeName())) {
                    defaultScriptList = VScriptParser.parseDefaultScripts(childNode);
                }
                ++i;
            }
            for (DefaultVScript defaultScript : defaultScriptList) {
                for (VScript script : scriptList) {
                    if (!defaultScript.getScriptId().equalsIgnoreCase(script.getId())) continue;
                    defaultScript.script = script;
                    break;
                }
                assert (defaultScript.script != null) : NLS.bind((String)Messages.VScriptParser_4, (Object)defaultScript.getScriptId());
            }
        }
        catch (Exception e) {
            LOGGER.severe(NLS.bind((String)Messages.VScriptParser_5, (Object)configFile, (Object)e.getMessage()));
            return null;
        }
        return new Scripts(scriptList, defaultScriptList);
    }
}

