/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.IChartView;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CABusView
implements IChartView {
    @Nullable
    private ScrolledComposite graphScrolledPanel;
    @Nullable
    private Canvas graphCanvas;
    @Nullable
    private VStagePresentation selectedStage;

    @Override
    public @Nullable Canvas createChart(CTabFolder scenTabFolder, @Nullable CTabItem diagsTab) {
        ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel = new ScrolledComposite((Composite)scenTabFolder, 2816);
        crtGraphScrolledPanel.setExpandHorizontal(true);
        crtGraphScrolledPanel.setExpandVertical(true);
        final Canvas crtGraphCanvas = this.graphCanvas = new Canvas((Composite)crtGraphScrolledPanel, 16);
        crtGraphCanvas.setData((Object)Messages.VScenarioView_diagsTabName);
        crtGraphCanvas.setLayout((Layout)new GridLayout(1, true));
        crtGraphCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createStatusLabel(crtGraphCanvas);
        crtGraphCanvas.addPaintListener(new PaintListener(){

            public void paintControl(@Nullable PaintEvent e) {
                String figureFilePath;
                VParamVariation selectedCell;
                VScenarioPresentation selectedScenario;
                if (CABusView.this.selectedStage != null && (selectedScenario = CABusView.this.selectedStage.getSelectedScenario()) != null && (selectedCell = selectedScenario.getSelectedCell()) != null && Files.exists(Paths.get(figureFilePath = TestResultsLogger.getFigureLogFilePath(selectedCell), new String[0]), new LinkOption[0])) {
                    ImageData imageData = new ImageData(figureFilePath);
                    Image image = new Image((Device)crtGraphCanvas.getDisplay(), imageData);
                    int imageWidth = image.getBounds().width;
                    int imageHeight = image.getBounds().height;
                    int canvasWidth = crtGraphCanvas.getBounds().width;
                    int canvasHeight = crtGraphCanvas.getBounds().height;
                    float scale = Math.min((float)canvasWidth / (float)imageWidth, (float)canvasHeight / (float)imageHeight);
                    GC gc = Objects.requireNonNull(Objects.requireNonNull(e).gc);
                    gc.setAntialias(1);
                    gc.setInterpolation(2);
                    gc.drawImage(image, 0, 0, imageWidth, imageHeight, 0, 0, (int)((float)imageWidth * scale), (int)((float)imageHeight * scale));
                }
            }
        });
        crtGraphScrolledPanel.setContent((Control)this.graphCanvas);
        crtGraphScrolledPanel.setDragDetect(true);
        CTabItem diagsTabLoc = diagsTab;
        if (diagsTabLoc != null && !diagsTabLoc.isDisposed()) {
            diagsTabLoc.setControl((Control)this.graphScrolledPanel);
        }
        return this.graphCanvas;
    }

    @Override
    public @Nullable Canvas setInput(VStagePresentation selectedStage, CTabFolder scenTabFolder, CTabItem diagsTab) {
        this.selectedStage = selectedStage;
        this.graphCanvas = this.createChart(scenTabFolder, diagsTab);
        if (this.graphCanvas != null) {
            this.graphCanvas.redraw();
        }
        return this.graphCanvas;
    }

    @Override
    public void setScenarioPaintListener(PaintListener paintListener) {
    }

    @Override
    public @Nullable Canvas createEmptyView(CTabFolder scenTabFolder, @Nullable CTabItem diagsTab) {
        ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel = new ScrolledComposite((Composite)scenTabFolder, 2816);
        crtGraphScrolledPanel.setExpandHorizontal(true);
        crtGraphScrolledPanel.setExpandVertical(true);
        Canvas crtGraphCanvas = this.graphCanvas = new Canvas((Composite)this.graphScrolledPanel, 0);
        this.createStatusLabel(crtGraphCanvas);
        return this.graphCanvas;
    }

    private void createStatusLabel(Canvas graph) {
        VTable table;
        VParamVariation cell;
        VTableGroup[] tableGroup;
        VScenarioPresentation scenario;
        GridData layoutData = new GridData(64, 64, true, true);
        graph.setLayoutData((Object)layoutData);
        graph.setLayout((Layout)new GridLayout(1, true));
        VStagePresentation stage = this.selectedStage;
        if (stage != null && (scenario = stage.getSelectedScenario()) != null && (tableGroup = scenario.getModel().getTableGroups()) != null && (cell = (table = tableGroup[0].getTables()[0]).getParamVariation(new Point(0, 0))) != null) {
            VRunResult runResult = cell.getResult(0);
            layoutData = new GridData(64, 64, true, true);
            layoutData.verticalAlignment = 128;
            layoutData.horizontalAlignment = 1;
            if (runResult != null) {
                if (runResult.getType() == VRunResult.ResultType.FAILED) {
                    Text text = new Text((Composite)graph, 515);
                    text.setText(runResult.getErrorMessage());
                    text.setLayoutData((Object)layoutData);
                    text.setVisible(true);
                } else if (runResult.getType() == VRunResult.ResultType.PASSED) {
                    String figureFilePath = TestResultsLogger.getFigureLogFilePath(cell);
                    if (!Files.exists(Paths.get(figureFilePath, new String[0]), new LinkOption[0])) {
                        Label label = new Label((Composite)graph, 1);
                        label.setText(Messages.DiagTestCollectingData);
                        label.setLayoutData((Object)layoutData);
                        label.setVisible(true);
                    }
                } else if (table.getState() == VTable.TableState.RUNNING) {
                    Label label = new Label((Composite)graph, 1);
                    label.setText(Messages.DiagTestNoData);
                    label.setLayoutData((Object)layoutData);
                    label.setVisible(true);
                }
            }
        }
    }
}

