/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CellLogsView
extends Composite {
    private static final int MIN_REFRESH_TIMEOUT = 10000;
    private Combo comCellTest;
    private StyledText logStyledText;
    private Combo logLevelCombo;
    private Button exportLogBtn;
    private String logLevelText;
    public static final String[] LEVELS = new String[]{"DEBUG", "INFO", "WARNING", "ERROR"};
    private transient ComboViewer comTestViewer;

    public CellLogsView(Composite parentView) {
        super(parentView, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        Label lblCellTest = new Label((Composite)this, 0);
        lblCellTest.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCellTest.setText(Messages.CellTestLabel);
        this.comCellTest = new Combo((Composite)this, 8);
        this.comCellTest.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.logLevelCombo = new Combo((Composite)this, 8);
        this.logLevelText = LEVELS[3];
        this.logLevelCombo.setItems(LEVELS);
        this.logLevelCombo.setText(this.logLevelText);
        this.logLevelCombo.addListener(24, new Listener(){

            public void handleEvent(@NonNull Event event) {
                CellLogsView.this.logLevelText = CellLogsView.this.logLevelCombo.getText();
            }
        });
        this.exportLogBtn = new Button((Composite)this, 8);
        this.exportLogBtn.setImage(Activator.getDefault().getImage("report.png"));
        this.exportLogBtn.setToolTipText(Messages.CellLogsExport);
        this.logStyledText = new StyledText((Composite)this, 2824);
        Display current = Display.getCurrent();
        if (current != null) {
            this.logStyledText.setBackground(current.getSystemColor(15));
        }
        this.logStyledText.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.logStyledText.getVerticalBar().setIncrement(10);
        this.comTestViewer = new ComboViewer(this.comCellTest);
        this.logStyledText.addListener(24, new Listener(){

            public void handleEvent(@NonNull Event event) {
                CellLogsView.this.logStyledText.setTopIndex(CellLogsView.this.logStyledText.getLineCount() - 1);
            }
        });
    }

    protected void checkSubclass() {
    }

    public void defaultFocus() {
        this.logStyledText.setFocus();
    }

    public ComboViewer getLogsComboViewer() {
        return this.comTestViewer;
    }

    public void makeDefaultSelection() {
        if (this.comTestViewer.getElementAt(0) != null) {
            this.comTestViewer.setSelection((ISelection)new StructuredSelection(this.comTestViewer.getElementAt(0)));
        }
    }

    public void refreshViewers() {
        this.comTestViewer.refresh();
    }

    public void setCellTestContentProvider(IStructuredContentProvider contentProvider) {
        this.comTestViewer.setContentProvider((IContentProvider)contentProvider);
    }

    public void setCellTestLabelProvider(ILabelProvider labelProvider) {
        this.comTestViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setInput(VParamVariation cell, @Nullable VModel vModel, boolean force) {
        if (vModel != null) {
            String levelsStr = vModel.getCustomOption("logLevelList");
            String[] levels = levelsStr != null ? levelsStr.split(" ") : LEVELS;
            String crtLogLevel = levels.length >= 4 ? levels[3] : LEVELS[3];
            this.logLevelCombo.setItems(levels);
            this.logLevelCombo.setText(crtLogLevel);
        }
        long currentTime = System.currentTimeMillis();
        if (!force && currentTime - cell.getLastRefreshTime() < 10000L) {
            return;
        }
        cell.setLastRefreshTime(currentTime);
        this.comTestViewer.setInput((Object)cell);
        VRunResult[] res = cell.getResults();
        if (res != null && res.length > 0) {
            String logFilePath;
            Path path;
            VRunResult selRunResult = res[0];
            this.comTestViewer.setSelection((ISelection)new StructuredSelection((Object)selRunResult), true);
            if (selRunResult.getType() == VRunResult.ResultType.QUEUED && (path = Paths.get(logFilePath = TestResultsLogger.getLogFilePath(selRunResult), new String[0])).toFile().exists()) {
                try {
                    this.logStyledText.setText(String.join((CharSequence)"\n", Files.readAllLines(path)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.logStyledText.setText("");
            this.logStyledText.setFocus();
        }
    }

    public void setLogsComboEnabled(boolean enabled) {
        this.comCellTest.setEnabled(enabled);
    }

    public void setLogsSelectionListener(ISelectionChangedListener selChangedListener) {
        this.comTestViewer.addPostSelectionChangedListener(selChangedListener);
    }

    public void setExportLogSelectionListener(SelectionListener listener) {
        this.exportLogBtn.addSelectionListener(listener);
    }

    public void setLogText(String text) {
        this.logStyledText.setText(text);
        this.logStyledText.setFocus();
    }

    public void setLogLevel(String level) {
        this.logLevelCombo.setText(level);
    }

    public void appendLogText(String text) {
        this.logStyledText.append(text);
    }

    public String getLogLevelText() {
        return this.logLevelText;
    }
}

