/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.listeners.FileBoolParamListener;
import com.nxp.swtools.mem.validation.listeners.FilePathParamListener;
import com.nxp.swtools.mem.validation.model.scripts.VScriptFileParamValue;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileParamView
extends Composite {
    private Button enabledCheckbox;
    private Button browseBtn;
    private Text path;

    public FileParamView(VScriptParam param, Composite parent) {
        super(parent, 0);
        GridLayout firstLayout = new GridLayout(3, false);
        firstLayout.marginWidth = 0;
        firstLayout.marginHeight = 0;
        this.setLayout((Layout)firstLayout);
        this.setLayoutData(new GridData(4, 4, true, false, 3, 1));
        this.enabledCheckbox = new Button((Composite)this, 32);
        this.enabledCheckbox.setLayoutData((Object)new GridData(16384, 0, false, false, 3, 1));
        this.enabledCheckbox.setToolTipText(param.getDescription());
        this.enabledCheckbox.setText(param.getName());
        Composite browseComposite = new Composite((Composite)this, 2048);
        GridLayout secondLayout = new GridLayout(3, false);
        secondLayout.marginWidth = 7;
        secondLayout.marginHeight = 7;
        browseComposite.setLayout((Layout)secondLayout);
        browseComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.path = new Text(browseComposite, 2048);
        this.path.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.path.setText("");
        final Button browseBtnRep = this.browseBtn = new Button(browseComposite, 0);
        browseBtnRep.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browseBtnRep.setText(Messages.BrowseInputTestFile);
        browseBtnRep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(browseBtnRep.getShell(), 4096);
                String inputFilePath = dialog.open();
                if (inputFilePath != null) {
                    FileParamView.this.path.setText(inputFilePath);
                    FileParamView.this.path.setSelection(FileParamView.this.path.getText().length());
                }
            }
        });
        ControlDecoration ctrlDecorator = new ControlDecoration((Control)this.path, 16512);
        ctrlDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        ctrlDecorator.setDescriptionText(Messages.INVALID_FILE_PATH);
        ctrlDecorator.hide();
        this.path.setData("qcs.validation.ddr.widget.decorator", (Object)ctrlDecorator);
        this.setEnabled(false);
    }

    public void setValue(VScriptFileParamValue paramValue) {
        this.enabledCheckbox.setSelection(paramValue.isEnabled());
        this.setEnabled(paramValue.isEnabled());
        if (paramValue.isEnabled()) {
            this.enabledCheckbox.notifyListeners(13, new Event());
        }
    }

    public void setEnabled(boolean enabledState) {
        if (!enabledState) {
            this.browseBtn.setEnabled(enabledState);
            this.path.setEnabled(enabledState);
        } else {
            this.browseBtn.setEnabled(this.enabledCheckbox.getSelection());
            this.path.setEnabled(this.enabledCheckbox.getSelection());
        }
    }

    public boolean isCheckBoxSelected() {
        return this.enabledCheckbox.getSelection();
    }

    public void setCheckboxState(boolean selection) {
        this.enabledCheckbox.setEnabled(selection);
    }

    public Text getFilePath() {
        return this.path;
    }

    public void addListeners(FileBoolParamListener boolListener, FilePathParamListener pathListener) {
        this.enabledCheckbox.addSelectionListener((SelectionListener)boolListener);
        this.path.addModifyListener((ModifyListener)pathListener);
    }
}

