/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.actions.ServiceTimeoutFactory;
import com.nxp.swtools.mem.validation.listeners.FileBoolParamListener;
import com.nxp.swtools.mem.validation.listeners.FilePathParamListener;
import com.nxp.swtools.mem.validation.listeners.TimeParamListener;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.ui.VScriptParamsView;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class VScenarioOptionsView
extends Composite {
    @Nullable
    private VScenarioPresentation presentation;
    private Button btnCheckSyncAll;
    private Label tableHorizontalLabel;
    private Table scriptConfigTable;
    private transient TableViewer scriptConfigTableViewer;
    private Spinner timeoutSpinner;
    private ScrolledComposite testParamsPanel;
    private transient TableViewerColumn scriptNameColumnViewer;
    @Nullable
    private EditingSupport scriptNameEditSupport;
    private transient TableViewerColumn scriptCountColumnViewer;
    private Map<String, VScriptParamsView> paramViews = new HashMap<String, VScriptParamsView>();
    private Map<VScriptParam.VScriptParamType, EventListener> paramListeners = new EnumMap<VScriptParam.VScriptParamType, EventListener>(VScriptParam.VScriptParamType.class);

    public VScenarioOptionsView(ScrolledComposite parentView) {
        super((Composite)parentView, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.tableHorizontalLabel = new Label((Composite)this, 0);
        GridData hGridData = new GridData(16384, 0, false, false, 2, 1);
        hGridData.horizontalSpan = 2;
        this.tableHorizontalLabel.setLayoutData((Object)hGridData);
        this.tableHorizontalLabel.setText(Messages.SelectScenarioLabel);
        this.btnCheckSyncAll = new Button((Composite)this, 32);
        this.btnCheckSyncAll.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.btnCheckSyncAll.setText(Messages.SyncSelectionLabel);
        Label emptyLabel = new Label((Composite)this, 0);
        emptyLabel.setVisible(true);
        Composite timeoutComposite = new Composite((Composite)this, 0);
        timeoutComposite.setLayoutData((Object)new GridData(16384, 0, false, false));
        timeoutComposite.setLayout((Layout)new GridLayout(2, true));
        timeoutComposite.setVisible(true);
        Label timeoutLabel = new Label(timeoutComposite, 0);
        timeoutLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        timeoutLabel.setText(Messages.TimeoutInputLabel);
        this.timeoutSpinner = new Spinner(timeoutComposite, 2048);
        this.timeoutSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.timeoutSpinner.setData((Object)Boolean.FALSE);
        this.timeoutSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutionPresentationModel execModel;
                if (VScenarioOptionsView.this.presentation != null && (execModel = VScenarioOptionsView.this.presentation.getParent().getParent().getParent().getExecution()) != null) {
                    execModel.setTestTimeout(VScenarioOptionsView.this.getTimeout());
                }
            }
        });
        this.timeoutSpinner.setMinimum(1);
        this.timeoutSpinner.setMaximum(Integer.MAX_VALUE);
        this.testParamsPanel = new ScrolledComposite((Composite)this, 2816);
        this.testParamsPanel.setExpandHorizontal(true);
        this.testParamsPanel.setExpandVertical(true);
        this.testParamsPanel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.scriptConfigTable = new Table((Composite)this, 67618);
        this.scriptConfigTable.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.scriptConfigTable.setHeaderVisible(true);
        this.scriptConfigTable.setLinesVisible(true);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.scriptConfigTable, "scriptConfigTable");
        this.scriptConfigTableViewer = new TableViewer(this.scriptConfigTable);
        this.scriptNameColumnViewer = new TableViewerColumn(this.scriptConfigTableViewer, 16384);
        this.scriptNameColumnViewer.getColumn().setText(Messages.TestLabel);
        this.scriptNameColumnViewer.getColumn().setWidth(200);
        this.scriptCountColumnViewer = new TableViewerColumn(this.scriptConfigTableViewer, 0x1000000);
        this.scriptCountColumnViewer.getColumn().setText(Messages.RepetitionLabel);
        this.scriptCountColumnViewer.getColumn().setWidth(70);
        this.scriptConfigTable.setData("qcs.validation.ddr.viewer", (Object)this.scriptConfigTableViewer);
    }

    public void addScriptParamListener(VScriptParam.VScriptParamType type, EventListener listener) {
        this.paramListeners.put(type, listener);
    }

    protected void checkSubclass() {
    }

    public void enable(boolean enabled) {
        this.setRecursiveEnabled((Control)this, enabled);
        this.timeoutSpinner.setEnabled(enabled);
        for (VScriptParamsView paramView : this.paramViews.values()) {
            paramView.enable(enabled);
        }
    }

    public Map<String, VScriptParamsView> getParamViews() {
        return this.paramViews;
    }

    public @Nullable VScenarioPresentation getPresentation() {
        return this.presentation;
    }

    public @Nullable EditingSupport getScriptNameEditSupport() {
        return this.scriptNameEditSupport;
    }

    public TableViewer getScriptsTableViewer() {
        return this.scriptConfigTableViewer;
    }

    public void setDoubleClickListener(MouseListener listener) {
        this.scriptConfigTableViewer.getTable().addMouseListener(listener);
    }

    public void setErrorMessages(VScriptConfig scriptConfig, Map<String, String> errorMap) {
        VScriptParamsView paramView = this.paramViews.get(scriptConfig.getScript().getId());
        if (paramView != null) {
            paramView.setErrors(errorMap);
        }
    }

    public void setInput(VScenarioPresentation data) {
        this.setInput(data, true);
    }

    public void setInput(@Nullable VScenarioPresentation input, boolean updateScriptConfigSelection) {
        this.presentation = input;
        if (this.presentation == null) {
            return;
        }
        this.initTimeout(this.getDefaultConnectionTimeout());
        VStagePresentation stage = Objects.requireNonNull(this.presentation).getParent();
        this.btnCheckSyncAll.setSelection(stage.getSyncScriptConfig());
        this.scriptConfigTableViewer.setSelection(null);
        this.scriptConfigTableViewer.setInput((Object)this.presentation);
        this.scriptConfigTableViewer.refresh();
        TableItem[] tableItemArray = this.scriptConfigTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            VScriptConfig itemData = (VScriptConfig)item.getData();
            if (itemData != null) {
                item.setChecked(itemData.isSelected());
            }
            ++n2;
        }
        VScriptConfig sc = Objects.requireNonNull(this.presentation).getSelectedScriptConfig();
        if (sc != null && updateScriptConfigSelection) {
            this.updateTestConfigurationUI(sc);
        }
        if (!Objects.requireNonNull(this.presentation).getParent().getParent().isAnyJobRunning()) {
            this.tableHorizontalLabel.setEnabled(true);
            this.btnCheckSyncAll.setEnabled(true);
        }
    }

    private void setRecursiveEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite && !(ctrl instanceof Table) && !(ctrl instanceof ToolBar)) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setRecursiveEnabled(c, enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    public void setScriptConfigContentProvider(IStructuredContentProvider contentProvider) {
        this.scriptConfigTableViewer.setContentProvider((IContentProvider)contentProvider);
    }

    public void setScriptCountEditingSupport(EditingSupport edSupport) {
        this.scriptCountColumnViewer.setEditingSupport(edSupport);
    }

    public void setScriptCountLabelProvider(ColumnLabelProvider lblProvider) {
        this.scriptCountColumnViewer.setLabelProvider((CellLabelProvider)lblProvider);
    }

    public void setScriptNameEditingSupport(EditingSupport edSupport) {
        this.scriptNameEditSupport = edSupport;
        this.scriptNameColumnViewer.setEditingSupport(edSupport);
    }

    public void setScriptNameLabelProvider(ColumnLabelProvider lblProvider) {
        this.scriptNameColumnViewer.setLabelProvider((CellLabelProvider)lblProvider);
    }

    public void setScriptSelectionListener(SelectionListener listener) {
        this.scriptConfigTableViewer.getTable().addSelectionListener(listener);
    }

    public void setSelectionListener(SelectionListener listener) {
        this.scriptConfigTableViewer.getTable().addSelectionListener(listener);
    }

    public void setSyncOptionListener(SelectionListener listener) {
        this.btnCheckSyncAll.addSelectionListener(listener);
    }

    public void updateScriptConfigTable(VScenarioPresentation data) {
        this.scriptConfigTableViewer.setInput((Object)data);
    }

    public void updateTestConfigurationUI(VScriptConfig scriptConfig) {
        this.scriptConfigTableViewer.setSelection((ISelection)new StructuredSelection((Object)scriptConfig));
        String viewId = scriptConfig.getScript().getId();
        VScriptParamsView paramView = this.paramViews.get(viewId);
        if (paramView == null) {
            TimeParamListener timeListener;
            SelectionListener optListener;
            EventListener sizeTextListener;
            EventListener hexTextListener;
            EventListener decTextListener;
            ModifyListener modifyListener;
            VScript script = scriptConfig.getScript();
            paramView = new VScriptParamsView((Composite)this.testParamsPanel, 0, script);
            SelectionListener selListener = (SelectionListener)this.paramListeners.get((Object)VScriptParam.VScriptParamType.BOOL);
            if (selListener != null) {
                paramView.addBoolSelectionListener(selListener);
            }
            if ((modifyListener = (ModifyListener)this.paramListeners.get((Object)VScriptParam.VScriptParamType.BYTE_PATTERN_HEX)) != null) {
                paramView.addBytePatternModifyListener(modifyListener);
            }
            if ((decTextListener = this.paramListeners.get((Object)VScriptParam.VScriptParamType.INT_DEC)) != null) {
                paramView.addTextListener(decTextListener, VScriptParam.VScriptParamType.INT_DEC);
            }
            if ((hexTextListener = this.paramListeners.get((Object)VScriptParam.VScriptParamType.INT_HEX)) != null) {
                paramView.addTextListener(hexTextListener, VScriptParam.VScriptParamType.INT_HEX);
            }
            if ((sizeTextListener = this.paramListeners.get((Object)VScriptParam.VScriptParamType.INT_SIZE_DEC)) != null) {
                paramView.addTextListener(sizeTextListener, VScriptParam.VScriptParamType.INT_SIZE_DEC);
            }
            if ((optListener = (SelectionListener)this.paramListeners.get((Object)VScriptParam.VScriptParamType.MULTI_OPT)) != null) {
                paramView.addComboSelectionListener(optListener);
            }
            if ((timeListener = (TimeParamListener)((Object)this.paramListeners.get((Object)VScriptParam.VScriptParamType.TIME))) != null) {
                paramView.addTimeListener(timeListener);
            }
            FileBoolParamListener fileBoolListener = (FileBoolParamListener)((Object)this.paramListeners.get((Object)VScriptParam.VScriptParamType.FILE));
            FilePathParamListener filePathListener = (FilePathParamListener)((Object)this.paramListeners.get((Object)VScriptParam.VScriptParamType.FILE_PATH));
            if (fileBoolListener != null && filePathListener != null) {
                paramView.addFileSelectionListeners(fileBoolListener, filePathListener);
            }
            this.paramViews.put(viewId, paramView);
        }
        paramView.setInput(scriptConfig);
        this.testParamsPanel.setContent((Control)paramView);
        this.testParamsPanel.setMinSize(paramView.computeSize(250, -1));
    }

    private long getDefaultConnectionTimeout() {
        Connection crtConnection;
        ExecutionPresentationModel execModel;
        if (this.presentation != null && (execModel = this.presentation.getParent().getParent().getParent().getExecution()) != null && (crtConnection = execModel.getConnection()) != null) {
            return ServiceTimeoutFactory.getServiceTimeout(crtConnection);
        }
        return -1L;
    }

    public long getTimeout() {
        return (long)this.timeoutSpinner.getSelection() * 1000L;
    }

    private void initTimeout(long value) {
        boolean initialized;
        if (!this.timeoutSpinner.isDisposed() && !(initialized = ((Boolean)Objects.requireNonNull(this.timeoutSpinner.getData())).booleanValue()) && value != -1L) {
            this.timeoutSpinner.setData((Object)Boolean.TRUE);
            this.timeoutSpinner.setSelection((int)(value / 1000L));
        }
    }
}

