/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.ui.UIResourceManager;
import com.nxp.swtools.mem.validation.utils.CollectionUtils;
import com.nxp.swtools.mem.validation.utils.LoggingUtils;
import com.nxp.swtools.mem.validation.utils.StringUtils;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VLoggingUtils
extends LoggingUtils {
    public static final String RM_BYTE_LANE_RESULTS_MSG = "Byte-lane results:";
    public static final int RM_NUM_LANE_RESULTS = 18;
    private static String[] HINT_CHECK_CONNECTION = new String[]{Messages.CheckJtag, Messages.CheckConn, Messages.CheckDevices};
    private static String[] HINT_CHECK_DDR_CONFIGURATION = new String[]{Messages.CheckDDRConfig};
    private static String[] HINT_VALIDATE_DDR_CONFIGURATION = new String[]{Messages.ValidateDDRConfigAdjust, Messages.ValidateDDRConfigCustom};
    private static String[] HINT_TRY_AGAIN = new String[]{Messages.TryAgain};
    private static String[] HINT_CHECK_BNDS = new String[]{Messages.CheckBndsBist, Messages.CheckBndsRegs};
    private static final String BIST_TEST_ID = "bist";
    public static final String APP_STATE = "app_state";
    public static final String PHY_ERROR_STATE = "phy_error_state";
    public static final String PHY_INIT_STATE = "Firmware has run successfully";
    public static final long APP_STATE_CONFIG_ERR = 219023885L;
    public static final String JSON_RECORDS = "records";
    public static final String JSON_STATE = "state";
    public static final String JSON_TEST_ID = "test_id";
    public static final String INIT_ERR_PREFIX = Messages.InitializationErrPrefix;
    public static final String INIT_ERR_POSTFIX = Messages.ErrPostfix;
    public static final String TEST_ERR_PREFIX = Messages.TestErrPrefix;
    public static final String TEST_ERR_POSTFIX = Messages.ErrPostfix;
    public static final String DEFAULT_INIT_ERROR_MSG = Messages.DefaultInitErrMsg;
    public static final String DEFAULT_TEST_ERROR_MSG = Messages.DefaultTestErrMsg;
    public static final String ERR_DISCONNECTED_FROM_SERVER = Messages.ErrDisconedctedFromServer;
    private static final Logger LOGGER = LogManager.getLogger(VLoggingUtils.class);

    private static final String buildHintMessage(String[] hintTokens) {
        assert (hintTokens != null && hintTokens.length > 0) : Messages.EmptyHintTokens;
        StringBuilder result = new StringBuilder(Messages.TroubleshootHeader);
        String[] stringArray = hintTokens;
        int n = hintTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String hint = stringArray[n2];
            result.append(StringUtils.EOL).append("-").append(hint);
            ++n2;
        }
        return result.toString();
    }

    public static String extractErrorMessage(String logResults) {
        String[] lines = logResults.split("\n");
        String errorMessage = null;
        boolean lastErrorMessage = false;
        int i = lines.length - 1;
        while (i >= 0) {
            Matcher phyMatcher;
            Matcher matcher = errorPattern.matcher(lines[i]);
            if (matcher.find() && !lastErrorMessage) {
                lastErrorMessage = true;
                errorMessage = lines[i];
            }
            if ((phyMatcher = phyFailurePattern.matcher(lines[i])).find()) {
                return String.format("{'%s' : '%s'}", PHY_ERROR_STATE, lines[i].substring(phyMatcher.start(), phyMatcher.end()));
            }
            Matcher failMatcher = failReasonPattern.matcher(lines[i]);
            if (failMatcher.find()) {
                return lines[i].split("([Ff][Aa][Ii][Ll][\\s][Rr][Ee][Aa][Ss][Oo][Nn][:][\\s])")[1];
            }
            --i;
        }
        if (errorMessage != null) {
            return errorMessage;
        }
        String[] stringArray = logResults.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = Pattern.compile("'app_state': \\d+").matcher(line);
            if (matcher.find()) {
                return line.substring(line.indexOf("{"));
            }
            ++n2;
        }
        stringArray = logResults.split("\n");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains(APP_STATE) && line.contains(String.valueOf(219023885L))) {
                return Messages.InvalidConfig;
            }
            ++n2;
        }
        return "";
    }

    public static boolean @Nullable [] extractRMByteLaneResults(String logResults) {
        if (logResults.isEmpty()) {
            return null;
        }
        boolean[] rmByteLaneResults = new boolean[18];
        String[] lines = logResults.split(CgenManager.LINE_SEPARATOR);
        int resultsStartLine = -1;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].contains(RM_BYTE_LANE_RESULTS_MSG)) {
                resultsStartLine = i + 1;
                break;
            }
            ++i;
        }
        if (resultsStartLine != -1) {
            i = resultsStartLine;
            int idx = 0;
            while (i < resultsStartLine + 18) {
                rmByteLaneResults[idx] = lines[i].toLowerCase().contains(Boolean.TRUE.toString());
                ++i;
                ++idx;
            }
        }
        return rmByteLaneResults;
    }

    public static @Nullable Color getFailureColor(ScriptResultType scriptFailureType) {
        switch (scriptFailureType) {
            case TEST_FAILED: {
                return Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_TEST_FAILED);
            }
            case CONFIGURATION_ERROR: {
                return Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_CONFIGURATION_ERROR);
            }
            case TARGET_ERROR: 
            case UNKNOWN_ERROR: {
                return Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_TARGET_ERROR);
            }
            case PASSED: {
                return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_BG");
            }
        }
        return null;
    }

    public static ScriptResultType getFailureType(@Nullable String errorMessage) {
        JSONObject jsonObject;
        if (errorMessage == null || errorMessage.isEmpty()) {
            return ScriptResultType.TARGET_ERROR;
        }
        try {
            jsonObject = new JSONObject(errorMessage);
        }
        catch (JSONException e) {
            LOGGER.info(e.getMessage());
            return ScriptResultType.TARGET_ERROR;
        }
        try {
            if (jsonObject.has(PHY_ERROR_STATE) && jsonObject.getString(PHY_ERROR_STATE) != null) {
                return ScriptResultType.CONFIGURATION_ERROR;
            }
            if (jsonObject.has(APP_STATE) && jsonObject.getLong(APP_STATE) == 219023885L) {
                return ScriptResultType.CONFIGURATION_ERROR;
            }
        }
        catch (JSONException e) {
            LOGGER.info(e.getMessage());
            return ScriptResultType.CONFIGURATION_ERROR;
        }
        try {
            if (jsonObject.has(JSON_RECORDS)) {
                JSONArray records = jsonObject.getJSONArray(JSON_RECORDS);
                int recIdx = 0;
                while (recIdx < records.length()) {
                    if (records.getJSONObject(recIdx).getInt(JSON_STATE) == 0) {
                        return ScriptResultType.TEST_FAILED;
                    }
                    ++recIdx;
                }
            }
        }
        catch (JSONException e) {
            LOGGER.info(e.getMessage());
            return ScriptResultType.TEST_FAILED;
        }
        return ScriptResultType.UNKNOWN_ERROR;
    }

    public static @Nullable String getHintMessage(VRunResult runResult) {
        String errorMessage = runResult.getErrorMessage();
        ScriptResultType scriptFailureType = VLoggingUtils.getFailureType(errorMessage);
        switch (scriptFailureType) {
            case CONFIGURATION_ERROR: {
                boolean isOperationalScenario = runResult.getParamVariation().getOperationalScriptConfig() != null;
                return isOperationalScenario ? VLoggingUtils.buildHintMessage(HINT_CHECK_DDR_CONFIGURATION) : VLoggingUtils.buildHintMessage(HINT_VALIDATE_DDR_CONFIGURATION);
            }
            case TARGET_ERROR: {
                return VLoggingUtils.buildHintMessage(HINT_CHECK_CONNECTION);
            }
            case TEST_FAILED: {
                VRunResult[] res;
                String testId = runResult.getScriptConfig().getScript().getId();
                boolean bistNoTurnoaround = testId.equals(VModel.ScriptId.BIST_NOTURN_TEST.id);
                boolean checkBndsHint = true;
                boolean bistTest = false;
                if (bistNoTurnoaround && (res = runResult.getParamVariation().getResults()) != null) {
                    VRunResult[] vRunResultArray = res;
                    int n = res.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VRunResult result = vRunResultArray[n2];
                        testId = result.getScriptConfig().getScript().getId();
                        if (testId.equals(VModel.ScriptId.BIST_NOTURN_TEST.id) || !testId.contains(BIST_TEST_ID)) break;
                        checkBndsHint = checkBndsHint && result.getType().equals((Object)VRunResult.ResultType.PASSED);
                        bistTest = true;
                        ++n2;
                    }
                }
                checkBndsHint = checkBndsHint && bistTest;
                return VLoggingUtils.buildHintMessage(checkBndsHint ? HINT_CHECK_BNDS : HINT_TRY_AGAIN);
            }
            case UNKNOWN_ERROR: {
                return VLoggingUtils.buildHintMessage(HINT_CHECK_CONNECTION);
            }
            case PASSED: {
                return null;
            }
        }
        return null;
    }

    public static ScriptResultType getWorstFailure(VRunResult[] vRunResults) {
        ScriptResultType failureType = ScriptResultType.PASSED;
        VRunResult[] vRunResultArray = vRunResults;
        int n = vRunResults.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptResultType newFailureType;
            VRunResult vRunResult = vRunResultArray[n2];
            String errorMessage = vRunResult.getErrorMessage();
            if (!errorMessage.isEmpty() && (newFailureType = VLoggingUtils.getFailureType(errorMessage)).ordinal() > failureType.ordinal()) {
                failureType = newFailureType;
            }
            ++n2;
        }
        return failureType;
    }

    public static enum ScriptResultType {
        PASSED(new String[0]),
        TEST_FAILED(Messages.TestInitFailed, Messages.TestFailed, Messages.Miscompare, Messages.TestFailedException, Messages.MemoryErrDetected, Messages.NotClearedMCTR, Messages.OtherIssues, Messages.InvestigateHwIssues, Messages.CorrectWriteLevelValues, Messages.Mismatch, Messages.DMAFail),
        CONFIGURATION_ERROR(Messages.TargetConfigErr, Messages.ErrDetect, Messages.TestNotRun, Messages.InvalidConfig, Messages.AutomaticCalibrationErr, Messages.InitiatizationFailed, Messages.ResetErr, Messages.PhyErr),
        TARGET_ERROR(Messages.ConnectingErr, Messages.SuspendingErr, Messages.LoadingErr, Messages.StartingErr, Messages.AppTimeout, Messages.InterruptedExc, Messages.MostRecentCall, Messages.NetworkTimeout, Messages.CableDisconnected, Messages.CCSErr, Messages.FailedToConnect, Messages.ScanTimeout, Messages.SubcoreErr, Messages.NotResponding),
        UNKNOWN_ERROR(new String[0]);

        String @Nullable [] errorTokens;

        private ScriptResultType(String ... errorTokens) {
            this.errorTokens = CollectionUtils.getSafeClone(errorTokens);
        }
    }
}

