/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class CompilerDefineSymbol {
    @NonNull
    final String name;
    @NonNull
    final String value;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(CompilerDefineSymbol.class);

    CompilerDefineSymbol(@NonNull String name, @NonNull String value) {
        this.name = name;
        this.value = value;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getValue() {
        return this.value;
    }

    public static @NonNull Collection<@NonNull CompilerDefineSymbol> readDefinesFromXml(@NonNull Element parentElem) {
        Element definesElem;
        List<Element> definesElems = ManifestLoaderUtils.getChildrenElements(parentElem, "defines");
        if (definesElems.isEmpty()) {
            return CollectionsUtils.emptyUnmodifiableList();
        }
        if (definesElems.size() > 1) {
            Element curElem = null;
            SdkTagContentVersion curVersion = SdkTagContentVersion.valueOf("0", "");
            for (Element elem : definesElems) {
                assert (elem != null);
                SdkTagContentVersion elemVersion = SdkTagContentVersion.valueOf(elem);
                if (elemVersion.compareTo(curVersion) <= 0) continue;
                curVersion = elemVersion;
                curElem = elem;
            }
            definesElem = curElem;
        } else {
            definesElem = definesElems.get(0);
        }
        assert (definesElem != null);
        List<Element> defineNodes = ManifestLoaderUtils.getChildrenElements(definesElem, "define");
        if (defineNodes.isEmpty()) {
            return CollectionsUtils.emptyUnmodifiableList();
        }
        Iterator<Element> iter = defineNodes.iterator();
        ArrayList<@NonNull CompilerDefineSymbol> result = new ArrayList<CompilerDefineSymbol>();
        while (iter.hasNext()) {
            Element defineElem = iter.next();
            String nameAttr = defineElem.getAttribute("name");
            String valueAttr = UtilsText.safeString((String)defineElem.getAttribute("value"));
            if (!nameAttr.isEmpty()) {
                result.add(new CompilerDefineSymbol(nameAttr, valueAttr));
                continue;
            }
            LOGGER.log(Level.WARNING, "Invalid define tag, missing 'name' attribute");
        }
        return result;
    }
}

