/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SdkDevicesDescriptor {
    @NonNull
    private @NonNull Map<@NonNull String, SdkDeviceDescriptor> sdkDeviceDescriptors;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkDevicesDescriptor.class);

    public SdkDevicesDescriptor(@NonNull Map<@NonNull String, SdkDeviceDescriptor> sdkDeviceDescriptors) {
        this.sdkDeviceDescriptors = sdkDeviceDescriptors;
    }

    public @NonNull Collection<SdkDeviceDescriptor> getSdkDeviceDescriptors() {
        return CollectionsUtils.unmodifiableCollection(this.sdkDeviceDescriptors.values());
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorByFullName(@NonNull String deviceFullName) {
        return this.sdkDeviceDescriptors.get(deviceFullName);
    }

    public @NonNull Set<@NonNull String> getSdkDeviceFullNames() {
        return CollectionsUtils.unmodifiableSet(this.sdkDeviceDescriptors.keySet());
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorByPackageId(@NonNull String packageId) {
        return (SdkDeviceDescriptor)CollectionsUtils.findFirst(this.getSdkDeviceDescriptors(), device -> device.getPackages().containsKey(packageId));
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorByPackageName(@NonNull String packageName) {
        return (SdkDeviceDescriptor)CollectionsUtils.findFirst(this.getSdkDeviceDescriptors(), device -> device.getPackageNames().contains(packageName));
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorById(@NonNull String id) {
        for (SdkDeviceDescriptor device : this.getSdkDeviceDescriptors()) {
            if (!id.equals(device.getId())) continue;
            return device;
        }
        return null;
    }

    public static class Builder {
        @NonNull
        private @NonNull Map<@NonNull String, SdkDeviceDescriptor> sdkDeviceDescriptors = new HashMap<String, SdkDeviceDescriptor>();

        public @NonNull Builder addSdkDeviceDescriptor(@NonNull SdkDeviceDescriptor sdkDeviceDescriptor) {
            SdkDeviceDescriptor cur = this.sdkDeviceDescriptors.get(sdkDeviceDescriptor.getFullName());
            if (cur == null || cur.getVersion().compareTo(sdkDeviceDescriptor.getVersion()) < 0) {
                this.sdkDeviceDescriptors.put(sdkDeviceDescriptor.getFullName(), sdkDeviceDescriptor);
            } else if (cur.getVersion().equals(sdkDeviceDescriptor.getVersion())) {
                LOGGER.log(Level.SEVERE, "Device duplicated in manifest: " + sdkDeviceDescriptor.getFullName());
            }
            return this;
        }

        public @NonNull SdkDevicesDescriptor build() {
            return new SdkDevicesDescriptor(this.sdkDeviceDescriptors);
        }
    }
}

