/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkOptionBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;

public class SdkOptionStrList
extends SdkOptionBase {
    @NonNull
    final @NonNull List<@NonNull String> values;
    @Nullable
    final List<@NonNull String> prevValues;
    final boolean replaceAllValues;
    @Nullable
    String valuesDelimiter;
    @Nullable
    public UnaryOperator<@NonNull String> convertExistingMergedValue;

    public SdkOptionStrList(@NonNull String optionId, @NonNull String name, @NonNull List<@NonNull String> values, @Nullable List<@NonNull String> prevValues, @NonNull String @NonNull [] variants, boolean replaceAllValues) {
        super(optionId, name, SdkOptionBase.SdkOptionType.STRING_LIST.getId(), variants);
        this.values = CollectionsUtils.unmodifiableList(values);
        this.prevValues = prevValues == null ? null : CollectionsUtils.unmodifiableList(prevValues);
        this.replaceAllValues = replaceAllValues;
    }

    public SdkOptionStrList(@NonNull String optionId, @NonNull String name, @NonNull List<@NonNull String> values, @Nullable List<@NonNull String> prevValues, @NonNull String @NonNull [] variants, boolean replaceAllValues, @NonNull String valuesDelimiter) {
        this(optionId, name, values, prevValues, variants, replaceAllValues);
        this.setValuesDelimiter(valuesDelimiter);
    }

    public SdkOptionStrList(@NonNull String optionId, @NonNull String name, @NonNull List<@NonNull String> values, @Nullable List<@NonNull String> prevValues, @NonNull String @NonNull [] variants, @NonNull UnaryOperator<@NonNull String> convertExistingMergedValue, @NonNull String valuesDelimiter) {
        this(optionId, name, values, prevValues, variants, false);
        this.setValuesDelimiter(valuesDelimiter);
        this.convertExistingMergedValue = convertExistingMergedValue;
    }

    public SdkOptionStrList(@NonNull String optionId, @NonNull String name, @NonNull String @NonNull [] arrValues, @NonNull String @NonNull [] variants, boolean replaceAllValues) {
        this(optionId, name, Arrays.asList(arrValues), null, variants, replaceAllValues);
    }

    public SdkOptionStrList(@NonNull String optionId, @NonNull String name, @NonNull List<@NonNull String> values, @Nullable List<@NonNull String> prevValues, @NonNull String typeAsString, @NonNull String @NonNull [] variants, boolean replaceAllValues) {
        super(optionId, name, typeAsString, variants);
        this.values = CollectionsUtils.unmodifiableList(values);
        this.prevValues = prevValues == null ? null : CollectionsUtils.unmodifiableList(prevValues);
        this.replaceAllValues = replaceAllValues;
    }

    public @NonNull List<@NonNull String> getValues() {
        return this.values;
    }

    public @Nullable List<@NonNull String> getPrevValues() {
        return this.prevValues;
    }

    public boolean replaceAllValues() {
        return this.replaceAllValues;
    }

    public @Nullable String getValuesDelimiter() {
        return this.valuesDelimiter;
    }

    public void setValuesDelimiter(@NonNull String delimiter) {
        if (delimiter.isEmpty()) {
            assert (false) : "invalid argument";
            delimiter = "\r";
        }
        this.valuesDelimiter = delimiter;
    }

    /*
     * Unable to fully structure code
     */
    public List<@NonNull String> mergeWithCurrentValues(@NonNull String curValues) {
        delimiter = this.valuesDelimiter;
        if (SdkOptionStrList.$assertionsDisabled || delimiter != null && !delimiter.isEmpty() && !this.replaceAllValues) ** GOTO lbl5
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            delimiter = delimiter.substring(0, delimiter.length() - 1);
lbl5:
            // 2 sources

            ** while (delimiter.length() > 1 && delimiter.endsWith((String)" "))
        }
lbl6:
        // 1 sources

        curValueList = new ArrayList<String>();
        curValueListAsEclipsePath = new HashSet<String>();
        var8_5 = curValues.trim().split(delimiter);
        var7_6 = var8_5.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            val = var8_5[var6_7];
            trimmed = val.trim();
            if (this.convertExistingMergedValue != null) {
                trimmed = (String)this.convertExistingMergedValue.apply(trimmed);
            }
            if (!(trimmed.isEmpty() || this.prevValues != null && this.prevValues.contains(trimmed) && !this.getValues().contains(trimmed))) {
                curValueList.add(trimmed);
                curValueListAsEclipsePath.add(UtilsFile.toEclipsePath((String)trimmed));
            }
            ++var6_7;
        }
        for (String aValue : this.getValues()) {
            if (curValueList.contains(aValue) || curValueListAsEclipsePath.contains(UtilsFile.toEclipsePath((String)aValue))) continue;
            curValueList.add(aValue);
        }
        return curValueList;
    }

    @Override
    public SdkOptionBase resolveVariables(SdkManifestDescriptor.ManifestHelper variablesResolver) {
        switch (this.getType()) {
            case STRING_LIST: {
                boolean changed = false;
                ArrayList<@NonNull String> resolvedValues = new ArrayList<String>();
                for (String value : this.values) {
                    String resolvedValue = variablesResolver.resolveVariables(value);
                    resolvedValues.add(resolvedValue);
                    if (resolvedValue.equals(value)) continue;
                    changed = true;
                }
                if (!changed) {
                    return this;
                }
                return new SdkOptionStrList(this.optionId, this.name, resolvedValues, this.prevValues, this.variants, this.replaceAllValues);
            }
            case UNKNOWN: {
                return this;
            }
        }
        assert (false);
        return this;
    }

    @Override
    public SdkOptionBase clone4Configuration(@NonNull String configuration) {
        if (!this.getConfigurationName().isEmpty() || configuration.isEmpty()) assert (false) : "configuration must be defined";
        ArrayList<@NonNull String> list4arr = new ArrayList<String>();
        list4arr.addAll(Arrays.asList(this.variants));
        list4arr.add("Configuration_" + configuration);
        SdkOptionStrList result = new SdkOptionStrList(this.optionId, this.name, this.values, this.prevValues, this.typeString, CollectionsUtils.toStringArr(list4arr), this.replaceAllValues);
        if (this.valuesDelimiter != null) {
            result.setValuesDelimiter(this.valuesDelimiter);
        }
        if (this.convertExistingMergedValue != null) {
            result.convertExistingMergedValue = this.convertExistingMergedValue;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SdkOptionStrList)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SdkOptionStrList opt = (SdkOptionStrList)obj;
        if (!this.values.equals(opt.values)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 11 + this.values.hashCode();
    }

    public String toString() {
        String printValue = String.valueOf('[') + CollectionsUtils.formatList(Arrays.asList(this.values), (String)",", null) + ']';
        return String.valueOf(this.getId()) + '/' + this.getName() + ':' + this.typeString + '=' + printValue;
    }
}

