/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.sdkmanifest.descriptors.CompilerDefineSymbol;
import com.nxp.swtools.sdkmanifest.descriptors.SdkOptionBase;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SdkToolchainsSettingsDescriptor {
    @NonNull
    private Map<String, SdkToolchainSettingDescriptor> toolchains;

    SdkToolchainsSettingsDescriptor() {
        this.toolchains = new HashMap<String, SdkToolchainSettingDescriptor>();
    }

    SdkToolchainsSettingsDescriptor(@NonNull Map<String, SdkToolchainSettingDescriptor> toolchains) {
        this.toolchains = toolchains;
    }

    public @NonNull Collection<SdkToolchainSettingDescriptor> getSdkToolchainSettingsDescr() {
        Collection<SdkToolchainSettingDescriptor> toolchainDescriptors = this.toolchains.values();
        assert (toolchainDescriptors != null);
        return CollectionsUtils.unmodifiableCollection(toolchainDescriptors);
    }

    public @Nullable SdkToolchainSettingDescriptor getSdkToolchainSettingsDescrByName(String name) {
        return this.toolchains.get(name);
    }

    public @Nullable SdkToolchainSettingDescriptor getSdkToolchainSettingsDescrById(@NonNull String id) {
        for (SdkToolchainSettingDescriptor descr : this.toolchains.values()) {
            if (!descr.getId().equals(id)) continue;
            return descr;
        }
        return null;
    }

    public @Nullable SdkToolchainSettingDescriptor findSdkToolchainSettingsDescrByUserName(String name) {
        for (SdkToolchainSettingDescriptor val : this.toolchains.values()) {
            if (!name.equals(val.getCaption())) continue;
            return val;
        }
        return null;
    }

    public @NonNull Collection<String> getSdkToolchainSettingsNames() {
        Set<String> names = this.toolchains.keySet();
        assert (names != null);
        return CollectionsUtils.unmodifiableCollection(names);
    }

    public static class Builder {
        @NonNull
        private Map<String, SdkToolchainSettingDescriptor> toolchains = new HashMap<String, SdkToolchainSettingDescriptor>();

        public @NonNull Builder addSdkToolchain(@NonNull SdkToolchainSettingDescriptor.Builder toolchain) {
            SdkToolchainSettingDescriptor toolchainDescriptor = toolchain.build();
            this.toolchains.put(toolchainDescriptor.getName(), toolchainDescriptor);
            return this;
        }

        public @NonNull SdkToolchainsSettingsDescriptor build() {
            return new SdkToolchainsSettingsDescriptor(this.toolchains);
        }
    }

    public static class SdkToolchainSettingDescriptor {
        @NonNull
        private String id;
        @NonNull
        private String name;
        @NonNull
        private final String toolchainId;
        @NonNull
        private final String compiler;
        @NonNull
        private String userName;
        @NonNull
        private Collection<SdkOptionBase> options;
        @NonNull
        private final @NonNull Collection<@NonNull CompilerDefineSymbol> defines;
        @NonNull
        private final SdkTagContentVersion version;

        SdkToolchainSettingDescriptor(@NonNull String id, @NonNull String name, @NonNull String toolchainId, @NonNull String compiler, @NonNull String userName, @NonNull Collection<SdkOptionBase> options, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, @NonNull SdkTagContentVersion version) {
            this.id = id;
            this.name = name;
            this.toolchainId = toolchainId;
            this.compiler = compiler;
            this.userName = userName;
            this.options = options;
            this.defines = defines;
            this.version = version;
        }

        public @NonNull String getId() {
            return this.id;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String getCompiler() {
            return this.compiler;
        }

        public @NonNull String getToolchainId() {
            return this.toolchainId;
        }

        public @NonNull String getCaption() {
            return this.userName;
        }

        public @NonNull Collection<SdkOptionBase> getOptions() {
            Collection<SdkOptionBase> optionValues = this.options;
            assert (optionValues != null);
            return CollectionsUtils.unmodifiableCollection(optionValues);
        }

        public @NonNull Collection<SdkOptionBase> getOptionsById(@NonNull String optionId) {
            ArrayList<SdkOptionBase> result = new ArrayList<SdkOptionBase>();
            for (SdkOptionBase opt : this.options) {
                if (!opt.getId().equals(optionId)) continue;
                result.add(opt);
            }
            return result;
        }

        public @NonNull Collection<SdkOptionBase> getOptionsForVariant(@Nullable String variant, boolean hack_disableLTO) {
            ArrayList<SdkOptionBase> selectedOptions = new ArrayList<SdkOptionBase>();
            block0: for (SdkOptionBase option : this.options) {
                if (hack_disableLTO && option.getId().equals("ilg.gnuarmeclipse.managedbuild.cross.option.optimization.lto")) continue;
                String[] stringArray = option.getVariants();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String optionVariant = stringArray[n2];
                    if (optionVariant.equals(variant)) {
                        selectedOptions.add(option);
                        continue block0;
                    }
                    ++n2;
                }
            }
            return selectedOptions;
        }

        public @NonNull Collection<@NonNull CompilerDefineSymbol> getDefines() {
            return this.defines;
        }

        @NonNull SdkTagContentVersion getVersion() {
            return this.version;
        }

        public static class Builder {
            @NonNull
            private String id;
            @NonNull
            private String name;
            @NonNull
            private final String toolchainId;
            @NonNull
            private String compiler;
            @NonNull
            private String userName;
            @NonNull
            private Collection<SdkOptionBase> options;
            @NonNull
            private final @NonNull Collection<@NonNull CompilerDefineSymbol> defines;
            @NonNull
            private final SdkTagContentVersion version;

            public Builder(@NonNull String id, @NonNull String name, @NonNull String toolchainId, @NonNull String compiler, @NonNull String userName, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, @NonNull SdkTagContentVersion version) {
                this.id = id;
                this.name = name;
                this.toolchainId = toolchainId;
                this.compiler = compiler;
                this.userName = userName;
                this.options = new ArrayList<SdkOptionBase>();
                this.defines = defines;
                this.version = version;
            }

            public @NonNull Builder addOption(@NonNull SdkOptionBase option) {
                this.options.add(option);
                return this;
            }

            public @NonNull Builder addOptions(@NonNull Collection<SdkOptionBase> optionsToAdd) {
                for (SdkOptionBase option : optionsToAdd) {
                    if (option == null) continue;
                    this.addOption(option);
                }
                return this;
            }

            public @NonNull SdkToolchainSettingDescriptor build() {
                return new SdkToolchainSettingDescriptor(this.id, this.name, this.toolchainId, this.compiler, this.userName, this.options, this.defines, this.version);
            }
        }
    }
}

