/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.parser;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.svd.parser.SvdTreeBuilder;
import com.nxp.s32ds.cdt.svd.parser.model.DimIndexType;
import com.nxp.s32ds.cdt.svd.parser.model.ParseRuntimeException;
import com.nxp.s32ds.cdt.svd.parser.model.ScaledNonNegativeInteger;
import java.math.BigInteger;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;

public interface DimGroup {
    public String getName();

    public ScaledNonNegativeInteger getDim();

    public ScaledNonNegativeInteger getDimIncrement();

    public DimIndexType getDimIndex();

    public static void walkDimGroup(SvdTreeBuilder builder, DimGroup dimGroup, BiConsumer<String, BigInteger> consumer) {
        Stream<String> indexesStream;
        String name = dimGroup.getName();
        int dim = dimGroup.getDim().getValue().intValue();
        ScaledNonNegativeInteger dimIncrement = dimGroup.getDimIncrement();
        if (dimIncrement == null) {
            throw new ParseRuntimeException(NLS.bind((String)Messages.SvdWalker_register_cluster_0_with_dimension_1_should_have_non_zero_attribute_dimincrement, (Object)name, (Object)dim));
        }
        DimIndexType dimIndex = dimGroup.getDimIndex();
        if (dimIndex == null) {
            indexesStream = IntStream.range(0, dim).boxed().map(i -> String.valueOf(i));
        } else {
            List<String> indexes = dimIndex.getIndexes();
            if (indexes.size() != dim) {
                throw new ParseRuntimeException(NLS.bind((String)Messages.SvdWalker_register_cluster_0_dimension_1_is_not_equal_to_index_size_2, (Object[])new Object[]{name, dim, indexes.size()}));
            }
            indexesStream = indexes.stream();
        }
        BigInteger[] offset = new BigInteger[]{BigInteger.ZERO};
        indexesStream.forEach(index -> consumer.accept(String.format(name, index), DimGroup.getAndAdd(offset, dimIncrement.getValue())));
    }

    public static BigInteger getAndAdd(BigInteger[] offset, BigInteger value) {
        BigInteger oldValue = offset[0];
        offset[0] = offset[0].add(value);
        return oldValue;
    }
}

