/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdModelBase;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SvdCompositeModel<T extends SvdModelBase>
extends SvdModelBase {
    private final Class<T> clazz;

    protected SvdCompositeModel(Class<T> clazz, Collection<T> models) {
        super(SvdCompositeModel.createUID(models), SvdSourceType.COMPOSITE, clazz);
        this.clazz = clazz;
        for (SvdModelBase svdModelBase : models) {
            this.add(svdModelBase);
        }
    }

    @Override
    public String getPath() {
        throw new IllegalStateException();
    }

    public List<T> getModels() {
        return this.getElements(this.clazz);
    }

    @Override
    public SvdChildElement getByShortPath(String path) {
        return this.getModels().stream().map(m -> m.getByShortPath(path)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public List<SvdPeripheralGroup> getPeripheralGroups() {
        return this.getModels().stream().map(SvdModelBase::getPeripheralGroups).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<SvdPeripheral> getPeripherals() {
        return this.getModels().stream().map(SvdModelBase::getPeripherals).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static String createUID(Collection<? extends SvdModelBase> models) {
        return String.join((CharSequence)"|", models.stream().map(m -> m.getUID()).collect(Collectors.toList()));
    }
}

