/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.ext.orbit.strings.SeparatedStrings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class SvdContainer
extends SvdChildElement {
    protected static final SeparatedStrings PATH_SEPARATED_STRINGS = new SeparatedStrings((CharSequence)"/");
    private final Set<SvdChildElement> children = new LinkedHashSet<SvdChildElement>();
    private final Class<?>[] allowedClasses;

    public SvdContainer(SvdContainer parent, String name, String description, Class<?> ... allowedClasses) {
        super(parent, name, description);
        this.allowedClasses = allowedClasses;
    }

    public SvdChildElement getByPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path argument is null");
        }
        String[] strings = SvdContainer.convertToNull(PATH_SEPARATED_STRINGS.asArray(path));
        SvdContainer container = this;
        SvdChildElement child = null;
        int i = 0;
        while (i < strings.length) {
            if (container == null) {
                return null;
            }
            child = container.getChild(strings[i]);
            if (child == null) {
                return null;
            }
            container = child instanceof SvdContainer ? (SvdContainer)child : null;
            ++i;
        }
        return child;
    }

    protected static String[] convertToNull(String[] strings) {
        int i = 0;
        while (i < strings.length) {
            if ("null".equals(strings[i])) {
                strings[i] = null;
            }
            ++i;
        }
        return strings;
    }

    public SvdChildElement getChild(String name) {
        Optional<SvdChildElement> optional = this.children.stream().filter(e -> Objects.equals(name, e.getName())).findAny();
        return optional.orElse(null);
    }

    public void add(SvdChildElement child) {
        if (child == null) {
            throw new IllegalArgumentException("Child argument is null");
        }
        if (!this.isAllowed(child)) {
            throw new IllegalArgumentException("Child should be instance of:\n" + String.join((CharSequence)" or ", Arrays.stream(this.allowedClasses).map(c -> c.getName()).collect(Collectors.toList())) + "\nbut was: " + child.getClass().getName());
        }
        if (this.children.contains(child)) {
            throw new IllegalStateException("Equal children already exist:" + child);
        }
        this.children.add(child);
    }

    private boolean isAllowed(SvdChildElement child) {
        int i = 0;
        while (i < this.allowedClasses.length) {
            if (this.allowedClasses[i].isInstance(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<SvdChildElement> getChildren() {
        return Collections.unmodifiableList(new ArrayList<SvdChildElement>(this.children));
    }

    public boolean deepEquals(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        SvdContainer other = (SvdContainer)obj;
        return this.children.equals(other.children);
    }

    @Override
    public Stream<SvdChildElement> flattened() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(SvdChildElement::flattened));
    }

    protected String getChildrenName() {
        return "children";
    }

    @Override
    public StringBuilder toString(String prefix, StringBuilder builder) {
        super.toString(prefix, builder);
        if (this.children.size() > 0) {
            builder.append(", ").append(this.getChildrenName()).append(":\n");
            int i = 0;
            for (SvdChildElement child : this.children) {
                child.toString(String.valueOf(prefix) + "\t", builder);
                if (i < this.children.size() - 1) {
                    builder.append("\n");
                }
                ++i;
            }
        }
        return builder;
    }

    protected <T> List<T> getElements(Class<T> t) {
        return Collections.unmodifiableList(this.getChildren().stream().filter(e -> t.isInstance(e)).map(e -> e).collect(Collectors.toList()));
    }

    @Deprecated
    public void remove(SvdChildElement childElement) {
        this.children.remove(childElement);
    }
}

