/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.internal.svd.parser.SvdParserUtils;
import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.parser.model.EnumUsageType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumeratedValueDataType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumeratedValueType;

public class SvdEnumeratedValue
extends SvdChildElement {
    private final EnumeratedValueDataType value;
    private final EnumUsageType usageType;

    public SvdEnumeratedValue(SvdField parent, EnumeratedValueType enumeratedValueType, EnumUsageType usageType) {
        super(parent, enumeratedValueType.getName(), SvdParserUtils.removeExtraSpaces(enumeratedValueType.getDescription()));
        this.value = enumeratedValueType.getValue();
        this.usageType = usageType;
    }

    public SvdEnumeratedValue(SvdField parent, SvdEnumeratedValue value) {
        super(parent, value.getName(), value.getDescription());
        this.value = value.getValue();
        this.usageType = value.getUsageType();
    }

    public EnumeratedValueDataType getValue() {
        return this.value;
    }

    public EnumUsageType getUsageType() {
        return this.usageType;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        return super.toString(builder).append(", value=").append(this.value).append(", usageType=").append((Object)this.usageType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.usageType == null ? 0 : this.usageType.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SvdEnumeratedValue)) {
            return false;
        }
        SvdEnumeratedValue other = (SvdEnumeratedValue)obj;
        if (this.usageType != other.usageType) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

