/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser.model;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.svd.parser.model.ParseRuntimeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class BitRangeType {
    private static final ThreadLocal<Matcher> THREAD_LOCAL = ThreadLocal.withInitial(() -> Pattern.compile("\\[(([0-4])?[0-9]):(([0-4])?[0-9])\\]").matcher(""));
    private final int msb;
    private final int lsb;

    public BitRangeType(int msb, int lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    public int getMsb() {
        return this.msb;
    }

    public int getLsb() {
        return this.lsb;
    }

    public int getOffset() {
        return this.getLsb();
    }

    public int getWidth() {
        return this.getMsb() - this.getOffset() + 1;
    }

    public static BitRangeType parseBitRangeType(String value) {
        int lsb;
        if (value == null || value.trim().isEmpty()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_not_be_empty, (Object)BitRangeType.class.getSimpleName()));
        }
        Matcher matcher = THREAD_LOCAL.get();
        matcher.reset(value);
        if (!matcher.matches()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_match_1, (Object)BitRangeType.class.getSimpleName(), (Object)"\\[([0-4])?[0-9]:([0-4])?[0-9]\\]"));
        }
        int msb = Integer.parseInt(matcher.group(1));
        if (msb < (lsb = Integer.parseInt(matcher.group(3)))) {
            throw new ParseRuntimeException(NLS.bind((String)Messages.BitRangeType_mbs_0_should_be_great_than_or_equal_to_lsb_1, (Object)msb, (Object)lsb));
        }
        return new BitRangeType(msb, lsb);
    }

    public String printBitRangeType() {
        return "[" + this.msb + ":" + this.lsb + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.lsb;
        result = 31 * result + this.msb;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitRangeType other = (BitRangeType)obj;
        if (this.lsb != other.lsb) {
            return false;
        }
        return this.msb == other.msb;
    }

    public String toString() {
        return this.printBitRangeType();
    }
}

