/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser.model;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.svd.parser.model.BitRangeType;
import com.nxp.s32ds.cdt.svd.parser.model.ParseRuntimeException;
import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class EnumeratedValueDataType {
    private static final String BINARY_1_PREFIX = "#";
    private static final String BINARY_2_PREFIX = "0b";
    private static final String HEX_PREFIX = "0x";
    private static final ThreadLocal<Matcher> THREAD_LOCAL = ThreadLocal.withInitial(() -> Pattern.compile("[+]?(0x|0b|#)?([0-9a-fx]+)").matcher(""));
    private final BigInteger value;
    private final BigInteger doNotCareMask;
    private final int doNotCareMaskLength;

    public EnumeratedValueDataType(BigInteger value, BigInteger doNotCareMask, int doNotCareMaskLength) {
        this.value = value;
        this.doNotCareMask = doNotCareMask;
        this.doNotCareMaskLength = doNotCareMaskLength;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getDoNotCareMask() {
        return this.doNotCareMask;
    }

    public static EnumeratedValueDataType parseEnumeratedValueDataType(String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_not_be_empty, (Object)BitRangeType.class.getSimpleName()));
        }
        Matcher matcher = THREAD_LOCAL.get();
        matcher.reset(value.trim().toLowerCase());
        if (!matcher.matches()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_match_1, (Object)EnumeratedValueDataType.class.getSimpleName(), (Object)"[+]?(((0x|0X)[0-9a-fA-F]+)|([0-9]+)|((#|0b)[01xX]+))"));
        }
        int radix = EnumeratedValueDataType.getRadix(matcher.group(1));
        String number = matcher.group(2);
        BigInteger doNotCareMask = BigInteger.ZERO;
        int doNotCareMaskLength = 0;
        if (radix == 2 && number.indexOf(120) >= 0) {
            doNotCareMask = EnumeratedValueDataType.extractDoNotCareMask(number);
            doNotCareMaskLength = number.length();
            number = EnumeratedValueDataType.extractNumber(number);
        }
        try {
            return new EnumeratedValueDataType(new BigInteger(number, radix), doNotCareMask, doNotCareMaskLength);
        }
        catch (NumberFormatException e) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._error_of_parsing_0_value_with_radix_1, (Object)value, (Object)radix), e);
        }
    }

    public static String extractNumber(String number) {
        return number.replace('x', '0');
    }

    public static BigInteger extractDoNotCareMask(String number) {
        StringBuilder builder = new StringBuilder(number.length());
        int i = 0;
        while (i < number.length()) {
            if (number.charAt(i) == 'x') {
                builder.append("1");
            } else {
                builder.append("0");
            }
            ++i;
        }
        return new BigInteger(builder.toString(), 2);
    }

    public String printEnumeratedValueDataType() {
        int l;
        if (this.doNotCareMaskLength == 0) {
            return HEX_PREFIX + this.value.toString(16);
        }
        String string = this.value.or(this.doNotCareMask).toString(2);
        char[] charArray = string.toCharArray();
        int i = l = charArray.length - 1;
        while (i >= 0) {
            if (this.doNotCareMask.testBit(l - i)) {
                charArray[i] = 120;
            }
            --i;
        }
        string = String.format("%" + this.doNotCareMaskLength + "s", new String(charArray)).replace(' ', '0');
        return BINARY_1_PREFIX + string;
    }

    private static int getRadix(String radix) {
        if (HEX_PREFIX.equals(radix)) {
            return 16;
        }
        if (BINARY_1_PREFIX.equals(radix) || BINARY_2_PREFIX.equals(radix)) {
            return 2;
        }
        return 10;
    }

    public int hashCode() {
        return Objects.hash(this.doNotCareMask, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumeratedValueDataType)) {
            return false;
        }
        EnumeratedValueDataType other = (EnumeratedValueDataType)obj;
        return Objects.equals(this.doNotCareMask, other.doNotCareMask) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return this.printEnumeratedValueDataType();
    }
}

