/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.validation.GtmValidatedTextfield;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import java.util.List;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.eclipse.ui.services.IDisposable;

public class IntegerSettingControl
extends HBox
implements IChildControl,
IDisposable {
    private GtmIntegerSetting integerSetting;
    protected Parent parent;
    private GtmValidatedTextfield integerSettingTxt;
    private ChangeListener<String> textfieldListener;

    public IntegerSettingControl(GtmIntegerSetting integerSetting, Parent parent) {
        this.integerSetting = integerSetting;
        this.parent = parent;
        this.integerSettingTxt = new GtmValidatedTextfield();
        this.textfieldListener = this.createIntegerTxtFieldListener();
        this.create();
        ChangeListener valueListener = (obs, oldValue, newValue) -> this.updateTextfieldStyle();
        integerSetting.getIsValueValidProperty().addListener(valueListener);
    }

    protected void updateTextfieldStyle() {
        List integerProblems = GtmController.getInstance().getProblemsManager().getProblemListForSource((IProblemSource)this.integerSetting);
        if (integerProblems.isEmpty()) {
            this.integerSettingTxt.resetStyle();
        } else {
            this.integerSettingTxt.setTextFieldErrorStyle();
        }
    }

    public void create() {
        this.setId(this.integerSetting.getId());
        Label integerSettingLbl = new Label(this.integerSetting.getLabel());
        integerSettingLbl.setContentDisplay(ContentDisplay.RIGHT);
        integerSettingLbl.getStyleClass().add((Object)"default-c-style");
        integerSettingLbl.setGraphic((Node)this.integerSettingTxt);
        integerSettingLbl.setPadding(new Insets(20.0));
        this.getChildren().add((Object)integerSettingLbl);
        this.getChildren().add((Object)this.integerSettingTxt);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.integerSetting);
        this.integerSettingTxt.setDisable(this.integerSetting.isReadOnly());
        this.integerSettingTxt.textProperty().addListener(this.textfieldListener);
        String initialValue = "0x" + Long.toHexString(UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue()));
        String modelValue = this.integerSetting.getCurrentValue();
        if (!NumberFormatValidator.isValidDecimal((String)modelValue) && !NumberFormatValidator.isValidHexadecimal((String)modelValue) && UctUtils.getLongValueFromString((String)modelValue) != 0L) {
            initialValue = modelValue;
        }
        this.integerSettingTxt.setText(initialValue);
        UctLayoutUtils.registerListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this, (int)4);
        GtmSceneCreator.getNodes().add((Node)this);
        GtmSceneCreator.getNodes().add((Node)this.integerSettingTxt);
        GtmSceneCreator.getNodes().add((Node)integerSettingLbl);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.integerSetting);
        long currentIntegerSettingTxtValue = UctUtils.getLongValueFromString((String)Objects.requireNonNull(this.integerSettingTxt.getText()));
        long currentIntegerSettingValue = -1L;
        if (NumberFormatValidator.isValidDecimal((String)this.integerSetting.getCurrentValue()) || UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue()) == 0L || NumberFormatValidator.isValidHexadecimal((String)this.integerSetting.getCurrentValue())) {
            currentIntegerSettingValue = UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue());
            if (currentIntegerSettingTxtValue != currentIntegerSettingValue) {
                this.integerSettingTxt.setText("0x" + Long.toHexString(currentIntegerSettingValue));
            }
        } else {
            this.integerSettingTxt.setText(this.integerSetting.getCurrentValue());
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    private ChangeListener<String> createIntegerTxtFieldListener() {
        return (observable, oldValue, newValue) -> {
            this.integerSetting.setCurrentValue(newValue);
            GtmController.getInstance().refreshCodeAndSourceView();
            StorageGtmUtils.updateStorageForComponent((Object)((Object)this), (ABaseUIComponentSetting)this.integerSetting);
        };
    }

    public ChangeListener<String> getTextfieldListener() {
        return this.textfieldListener;
    }

    public GtmIntegerSetting getIntegerSetting() {
        return this.integerSetting;
    }

    public void dispose() {
        this.integerSettingTxt.textProperty().removeListener(this.textfieldListener);
        this.integerSetting.removePropertyChangeListener(GtmController.getInstance().getValidationHandler().getValueChangeListener());
        GtmController.getInstance().getProblemsManager().clearProblems((IProblemSource)this.integerSetting);
        UctLayoutUtils.removeListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this);
        GtmSceneCreator.getNodes().remove((Object)this);
        GtmSceneCreator.getNodes().remove(this.integerSettingTxt);
        this.getChildren().clear();
    }
}

