/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeItemSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeStructSetting;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.gui.utils.GtmToolActions;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmXmlConfiguration;
import javafx.beans.value.ChangeListener;
import javafx.scene.Scene;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.eclipse.ui.services.IDisposable;

public class TreeStructSettingNode
extends TreeView<String>
implements IBaseControl,
IDisposable {
    private TreeStructSetting treeStruct;
    private ChangeListener<TreeItem<String>> selectionListener;

    public TreeStructSettingNode(TreeStructSetting treeStruct) {
        this.treeStruct = treeStruct;
        this.selectionListener = this.createSelectionListener();
        this.create();
    }

    public void create() {
        TreeItem rootItem = new TreeItem((Object)this.treeStruct.getLabel());
        for (TreeItemSetting treeItemSettingInStruct : this.treeStruct.getTreeItems()) {
            TreeItem treeItemInStruct = new TreeItem((Object)treeItemSettingInStruct.getLabel());
            treeItemInStruct.setExpanded(true);
            for (TreeItemSetting childTreeItemSetting1 : treeItemSettingInStruct.getTreeItems()) {
                TreeItem childTreeItem1 = new TreeItem((Object)childTreeItemSetting1.getLabel());
                childTreeItem1.setExpanded(true);
                for (TreeItemSetting childTreeItemSetting2 : childTreeItemSetting1.getTreeItems()) {
                    TreeItem childTreeItem2 = new TreeItem((Object)childTreeItemSetting2.getLabel());
                    childTreeItem1.getChildren().add((Object)childTreeItem2);
                }
                treeItemInStruct.getChildren().add((Object)childTreeItem1);
            }
            rootItem.getChildren().add((Object)treeItemInStruct);
        }
        this.setRoot(rootItem);
        this.setShowRoot(false);
        this.getRoot().setExpanded(true);
        this.getSelectionModel().selectedItemProperty().addListener(this.selectionListener);
    }

    private ChangeListener<TreeItem<String>> createSelectionListener() {
        return (observable, oldValue, newValue) -> {
            TreeItemSetting itemSetting = UctXmlSettingsUtils.getTreeItemByLabel((TreeStructSetting)this.getTreeStruct(), (String)((String)newValue.getValue()));
            if (itemSetting != null) {
                GtmLayoutUtils.resetAllStructSettingsState();
                if (!itemSetting.getAction().isEmpty()) {
                    GtmToolActions.executeAction(itemSetting.getAction());
                    GtmUtils.checkVisibleStateBasedOnContraints((GtmXmlConfiguration)GtmController.getInstance().getGtmXmlConfig(), (IGtmMcu)GtmController.getInstance().getGtmMcu());
                    this.refreshScene();
                }
            }
        };
    }

    public ChangeListener<TreeItem<String>> getSelectionListener() {
        return this.selectionListener;
    }

    protected void refreshScene() {
        Scene scene = this.getScene();
        if (scene != null) {
            GtmLayoutUtils.refreshUI(scene);
        }
    }

    public void dispose() {
        MultipleSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.selectedItemProperty().removeListener(this.selectionListener);
        }
        this.getChildren().clear();
    }

    public TreeStructSetting getTreeStruct() {
        return this.treeStruct;
    }
}

