/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.core;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class ProjectConfigurationUtils {
    private ProjectConfigurationUtils() {
    }

    public static List<IProject> getMultiCoreProjects(IConfiguration configuration) {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(configuration.getOwner().getProject());
        ICConfigurationDescription configurationDescription = projectDescription.getConfigurationByName(configuration.getName());
        if (configurationDescription != null) {
            return configurationDescription.getReferenceInfo().keySet().stream().map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getProject(arg_0)).filter(IResource::isAccessible).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static IConfiguration getDefaultConfiguration(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            return buildInfo.getDefaultConfiguration();
        }
        return null;
    }

    public static String getDefaultToolChainId(IProject project) {
        String toolChainId = null;
        IConfiguration defaultConfiguration = ProjectConfigurationUtils.getDefaultConfiguration(project);
        if (defaultConfiguration != null) {
            IToolChain toolChain = defaultConfiguration.getToolChain();
            if (toolChain != null) {
                toolChainId = toolChain.getBaseId();
            }
        } else {
            toolChainId = new ProjectContextSettings(project).getToolChain2Context();
        }
        return toolChainId;
    }

    public static List<IConfiguration> getProjectConfigurations(IProject project) {
        if (project == null) {
            ProjectConfigurationCoreActivator.getInstance().logError("Project is null.");
            return Collections.emptyList();
        }
        if (!project.isAccessible()) {
            ProjectConfigurationCoreActivator.getInstance().logError(NLS.bind((String)"Project {0} is inaccessible.", (Object)project.getName()));
            return Collections.emptyList();
        }
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            ProjectConfigurationCoreActivator.getInstance().logError(NLS.bind((String)"Cannot retrive Managed Build Info for project {0}.", (Object)project.getName()));
            return Collections.emptyList();
        }
        IManagedProject managedProject = buildInfo.getManagedProject();
        if (managedProject == null) {
            ProjectConfigurationCoreActivator.getInstance().logError(NLS.bind((String)"Cannot retrive Managed Project for project {0}.", (Object)project.getName()));
            return Collections.emptyList();
        }
        IConfiguration[] configurations = managedProject.getConfigurations();
        if (configurations == null) {
            ProjectConfigurationCoreActivator.getInstance().logError(NLS.bind((String)"Cannot retrive configurations for project {0}.", (Object)project.getName()));
            return Collections.emptyList();
        }
        return Stream.of(configurations).collect(Collectors.toList());
    }
}

