/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.SettingsUpdateData;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.OptionUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectConfigurationInfo;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectSettingsUpdaterBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class OptionUpdater
extends ProjectSettingsUpdaterBase {
    @Override
    public IStatus update(IConfiguration configuration, String optionId, String optionValue, UpdateOperation operation) {
        IStatus status = this.validateArguments(configuration, optionId, optionValue, operation);
        if (!status.isOK()) {
            return status;
        }
        return this.update(configuration, optionId, Collections.singletonList(optionValue), operation);
    }

    @Override
    public IStatus update(IConfiguration configuration, String optionId, Collection<String> optionValues, UpdateOperation operation) {
        IStatus status = this.validateArguments(configuration, optionId, optionValues, operation);
        if (!status.isOK()) {
            return status;
        }
        return this.update(configuration, Collections.singletonList(new SettingsUpdateData(optionId, optionValues, operation)));
    }

    @Override
    public IStatus update(IConfiguration configuration, Collection<SettingsUpdateData> optionsUpdateData) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        try {
            ProjectConfigurationInfo info = ProjectConfigurationInfo.create(configuration);
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            MultiStatus result = ProjectConfigurationCoreActivator.getInstance().createMultiStatus();
            try {
                boolean changed = false;
                for (SettingsUpdateData optionUpdateData : optionsUpdateData) {
                    String optionId = optionUpdateData.getName();
                    ArrayList<String> optionValues = new ArrayList<String>(optionUpdateData.getValues());
                    UpdateOperation operation = optionUpdateData.getOperation();
                    changed |= this.setOptionValues(info.configuration, optionId, optionValues, operation, result);
                }
                if (changed) {
                    ManagedBuildManager.saveBuildInfo((IProject)info.project, (boolean)true);
                }
            }
            finally {
                workspaceDesc.setAutoBuilding(autoBuilding);
                workspace.setDescription(workspaceDesc);
            }
            CoreModel.getDefault().setProjectDescription(info.project, info.projectDescription);
            return result;
        }
        catch (CoreException e) {
            return OptionUpdater.handleException("option", optionsUpdateData, e);
        }
    }

    private boolean setOptionValues(IConfiguration configuration, String optionId, List<String> optionValues, UpdateOperation operation, MultiStatus result) {
        ITool[] tools;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)configuration.getOwner());
        if (buildInfo == null) {
            return false;
        }
        if (buildInfo.getManagedProject() == null) {
            return false;
        }
        boolean modified = false;
        IToolChain toolChain = configuration.getToolChain();
        modified |= this.setOptionValues(optionId, optionValues, configuration, toolChain.getOptions(), (IHoldsOptions)toolChain, operation, result);
        ITool[] iToolArray = tools = configuration.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            modified |= this.setOptionValues(optionId, optionValues, configuration, tool.getOptions(), (IHoldsOptions)tool, operation, result);
            ++n2;
        }
        return modified;
    }

    private boolean setOptionValues(String optionId, List<String> optionValues, IConfiguration config, IOption[] options, IHoldsOptions optionHolder, UpdateOperation operation, MultiStatus result) {
        boolean modified = false;
        List filteredOptions = Arrays.stream(options).filter(option -> option.getBaseId().matches("(?i:" + optionId + ")")).collect(Collectors.toList());
        for (IOption option2 : filteredOptions) {
            ArrayList<String> optionValuesCopy = new ArrayList<String>(optionValues);
            try {
                int valueType = option2.getValueType();
                Set<String> currentOptionValues = OptionUpdater.getOptionValues(option2);
                if (currentOptionValues == null) continue;
                OptionUpdateStatus updateStatus = new OptionUpdateStatus(option2.getBaseId(), config.getName(), "");
                updateStatus.setSourceValues(currentOptionValues);
                switch (operation) {
                    case ADD: {
                        updateStatus.setSkippedValues(this.addOptionValues(currentOptionValues, optionValuesCopy, valueType));
                        break;
                    }
                    case REMOVE: {
                        this.removeOptionValues(currentOptionValues, optionValuesCopy);
                        break;
                    }
                    case REPLACE_EXISTING: {
                        updateStatus.setSkippedValues(this.replaceOptionValues(currentOptionValues, optionValuesCopy));
                        break;
                    }
                    case CLEAN_EXISTING: {
                        currentOptionValues.clear();
                    }
                }
                String[] values = currentOptionValues.toArray(new String[0]);
                switch (valueType) {
                    case 1: 
                    case 2: {
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option2, (String)(values.length > 0 ? values[0] : ""));
                        break;
                    }
                    case 0: {
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option2, (values.length > 0 && Boolean.parseBoolean(values[0]) ? 1 : 0) != 0);
                        break;
                    }
                    default: {
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option2, (String[])values);
                    }
                }
                updateStatus.setTargetValues(Arrays.asList(values));
                result.add((IStatus)updateStatus);
                modified = true;
            }
            catch (BuildException be) {
                IStatus errorStatus = ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)Messages.OptionUpdater_error_update_option_value, (Object)optionId, optionValues), be);
                ProjectConfigurationCoreActivator.getInstance().log(errorStatus);
            }
        }
        return modified;
    }

    protected Set<String> addOptionValues(Set<String> currentOptionValues, List<String> optionValues, int valueType) {
        Set<String> skippedValues = OptionUpdater.getSkippedValues(currentOptionValues, optionValues);
        if (!skippedValues.isEmpty()) {
            optionValues.removeAll(skippedValues);
        }
        if (!optionValues.isEmpty()) {
            switch (valueType) {
                case 0: 
                case 1: 
                case 2: {
                    currentOptionValues.clear();
                    currentOptionValues.add(optionValues.get(0));
                    break;
                }
                default: {
                    currentOptionValues.addAll(optionValues);
                }
            }
        }
        return skippedValues;
    }

    protected void removeOptionValues(Set<String> currentOptionValues, List<String> optionValues) {
        currentOptionValues.removeAll(optionValues);
    }

    protected Set<String> replaceOptionValues(Set<String> currentOptionValues, List<String> optionValues) {
        Set<String> skippedValues = OptionUpdater.getSkippedValues(currentOptionValues, optionValues);
        currentOptionValues.clear();
        currentOptionValues.addAll(optionValues);
        return skippedValues;
    }

    private static Set<String> getSkippedValues(Set<String> currentOptionValues, List<String> optionValues) {
        return optionValues.stream().filter(currentOptionValues::contains).collect(Collectors.toSet());
    }

    private static Set<String> getOptionValues(IOption option) throws BuildException {
        String[] list = null;
        switch (option.getValueType()) {
            case 4: {
                list = option.getIncludePaths();
                break;
            }
            case 8: {
                list = option.getBasicStringListValue();
                break;
            }
            case 5: {
                list = option.getDefinedSymbols();
                break;
            }
            case -5: {
                list = option.getBasicStringListValue();
                break;
            }
            case 9: {
                list = option.getLibraryPaths();
                break;
            }
            case 6: {
                list = option.getLibraries();
                break;
            }
            case 3: {
                list = option.getStringListValue();
                break;
            }
            case 1: 
            case 2: {
                return new LinkedHashSet<String>(Arrays.asList(option.getStringValue()));
            }
            case 0: {
                return new LinkedHashSet<String>(Arrays.asList(String.valueOf(option.getBooleanValue())));
            }
        }
        return list != null ? new LinkedHashSet<String>(Arrays.asList(list)) : null;
    }
}

