/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.projectgenerator;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectGeneratorComponentSet;
import java.util.Arrays;
import java.util.Collection;

public enum ComponentType {
    MIDDLEWARE("middleware", "middleware", StorageProjectGeneratorComponentSet.ComponentSelection.NONE),
    DRIVER("driver", "driver", StorageProjectGeneratorComponentSet.ComponentSelection.ALL),
    UTILITY("utility", "utilities", StorageProjectGeneratorComponentSet.ComponentSelection.ALL),
    CMSIS_DRIVER("CMSIS_driver", "CMSIS_driver", StorageProjectGeneratorComponentSet.ComponentSelection.NONE),
    BOARD_COMPONENT("board_component", "board_component", StorageProjectGeneratorComponentSet.ComponentSelection.NONE),
    ABSTRACTION_LAYER("abstraction_layer", "abstraction_layer", StorageProjectGeneratorComponentSet.ComponentSelection.NONE),
    SOFTWARE_COMPONENT("software_component", "software_component", StorageProjectGeneratorComponentSet.ComponentSelection.NONE),
    UNSUPPORTED("unsupported", "", StorageProjectGeneratorComponentSet.ComponentSelection.NONE);

    @NonNull
    private final String typeId;
    @NonNull
    private final String sdkCompType;
    @NonNull
    private final StorageProjectGeneratorComponentSet.ComponentSelection defaultSelection;

    private ComponentType(@NonNull String typeId, String sdkCompType, StorageProjectGeneratorComponentSet.ComponentSelection defaultSelection) {
        this.typeId = typeId;
        this.sdkCompType = sdkCompType;
        this.defaultSelection = defaultSelection;
    }

    public @NonNull String getId() {
        return this.typeId;
    }

    public @NonNull String getSdkCompType() {
        return this.sdkCompType;
    }

    public @NonNull StorageProjectGeneratorComponentSet.ComponentSelection getDefaultSelection() {
        return this.defaultSelection;
    }

    public static @NonNull ComponentType fromString(@NonNull String typeId) {
        ComponentType[] componentTypeArray = ComponentType.values();
        int n = componentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentType t = componentTypeArray[n2];
            if (t.getId().equals(typeId)) {
                return t;
            }
            ++n2;
        }
        return UNSUPPORTED;
    }

    public static @Nullable ComponentType fromSdkCompType(@NonNull String sdkCompType) {
        for (ComponentType t : ComponentType.supportedValues()) {
            if (!t.getSdkCompType().equals(sdkCompType)) continue;
            return t;
        }
        return null;
    }

    public static @NonNull Collection<@NonNull ComponentType> supportedValues() {
        return (Collection)Arrays.asList(ComponentType.values()).stream().filter(v -> !UNSUPPORTED.equals(v)).collect(CollectorsUtils.toList());
    }
}

