/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.yaml.IYamlConvertible;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeAhb;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeApuConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeFuncGroupDelegate;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeFunctionalGroup;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeGlobalOption;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMpuBank;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeProfile;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeRdc;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSau;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSecurityPeripheralBase;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTrdc;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeUserMemoryRegionConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeXrdc2;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeXtrdc;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(strict=false, name="tee")
@Order(elements={"generated_project_files", "tee_profile", "ahb", "trdc", "xrdc2", "rdc", "sau", "global_options", "user_memory_regions", "mpus"})
public class StorageTeeTool
extends StorageTool
implements IYamlConvertible {
    private static final Logger LOGGER = LogManager.getLogger(StorageTeeTool.class);
    public static final int YAML_RADIX = 16;
    public static final String TOOL_VERSION = StorageTeeTool.findVersion("TEE");
    public static final String INIT_FN_NAME = "BOARD_InitTEE";
    public static final String GLB_OPT_OUTPUT_TYPE = "_output_type_";
    public static final String GLB_OPT_LEGACY_SOURCE_NAMES = "_legacy_source_names_";
    private static final List<String> TOOL_OPTIONS = new ArrayList<String>(Arrays.asList("_output_type_", "_legacy_source_names_"));
    @Element(name="tee_profile", required=false)
    private StorageTeeProfile teeProfile = new StorageTeeProfile();
    private final StorageTeeFuncGroupDelegate funcGroupDelegate = new StorageTeeFuncGroupDelegate();
    @ElementList(entry="functional_group", inline=true, required=false)
    @Nullable
    private @ElementList(entry="functional_group", inline=true, required=false) @Nullable List<StorageTeeFunctionalGroup> funcGroups;

    public StorageTeeTool() {
        super("TEE", TOOL_VERSION);
    }

    @ElementUnion(value={@Element(required=false, name="ahb", type=StorageTeeAhb.class), @Element(required=false, name="rdc", type=StorageTeeRdc.class), @Element(required=false, name="xrdc2", type=StorageTeeXrdc2.class), @Element(required=false, name="trdc", type=StorageTeeTrdc.class), @Element(required=false, name="xtrdc", type=StorageTeeXtrdc.class)})
    public @ElementUnion(value={@Element(required=false, name="ahb", type=StorageTeeAhb.class), @Element(required=false, name="rdc", type=StorageTeeRdc.class), @Element(required=false, name="xrdc2", type=StorageTeeXrdc2.class), @Element(required=false, name="trdc", type=StorageTeeTrdc.class), @Element(required=false, name="xtrdc", type=StorageTeeXtrdc.class)}) @Element(required=false, name="ahb", type=StorageTeeAhb.class) @Element(required=false, name="rdc", type=StorageTeeRdc.class) @Element(required=false, name="xrdc2", type=StorageTeeXrdc2.class) @Element(required=false, name="trdc", type=StorageTeeTrdc.class) @Element(required=false, name="xtrdc", type=StorageTeeXtrdc.class) @Nullable StorageTeeSecurityPeripheralBase getSecurityPeripheral() {
        return null;
    }

    @ElementUnion(value={@Element(required=false, name="ahb", type=StorageTeeAhb.class), @Element(required=false, name="rdc", type=StorageTeeRdc.class), @Element(required=false, name="xrdc2", type=StorageTeeXrdc2.class), @Element(required=false, name="trdc", type=StorageTeeTrdc.class), @Element(required=false, name="xtrdc", type=StorageTeeXtrdc.class)})
    public void setSecurityPeripheral(@Nullable StorageTeeSecurityPeripheralBase securityPeripheral) {
        this.funcGroupDelegate.setSecurityPeripheral(securityPeripheral);
    }

    @Element(name="sau", required=false)
    public @Element(name="sau", required=false) @Nullable StorageTeeSau getSau() {
        return null;
    }

    @Element(name="sau", required=false)
    public void setSau(@Nullable StorageTeeSau sau) {
        this.funcGroupDelegate.setSau(sau);
    }

    @ElementList(inline=false, required=false, type=StorageTeeGlobalOption.class, name="global_options", entry="option")
    public @ElementList(inline=false, required=false, type=StorageTeeGlobalOption.class, name="global_options", entry="option") @Nullable ArrayList<StorageTeeGlobalOption> getGlobalOptions() {
        return null;
    }

    @ElementList(inline=false, required=false, type=StorageTeeGlobalOption.class, name="global_options", entry="option")
    public void setGlobalOptions(ArrayList<StorageTeeGlobalOption> options) {
        this.funcGroupDelegate.setGlobalOptions(new ArrayList<StorageTeeGlobalOption>(options));
    }

    @ElementList(inline=false, required=false, type=StorageTeeUserMemoryRegionConfig.class, name="user_memory_regions", entry="user_memory_region")
    public @ElementList(inline=false, required=false, type=StorageTeeUserMemoryRegionConfig.class, name="user_memory_regions", entry="user_memory_region") @Nullable ArrayList<StorageTeeUserMemoryRegionConfig> getUserMemRegions() {
        return null;
    }

    @ElementList(inline=false, required=false, type=StorageTeeUserMemoryRegionConfig.class, name="user_memory_regions", entry="user_memory_region")
    public void setUserMemRegions(ArrayList<StorageTeeUserMemoryRegionConfig> list) {
        this.funcGroupDelegate.setUserMemRegions(new ArrayList<StorageTeeUserMemoryRegionConfig>(list));
    }

    @ElementList(inline=false, required=false, type=StorageTeeApuConfig.class, name="apus", entry="apu")
    public @ElementList(inline=false, required=false, type=StorageTeeApuConfig.class, name="apus", entry="apu") @Nullable ArrayList<StorageTeeApuConfig> getApus() {
        return null;
    }

    @ElementList(inline=false, required=false, type=StorageTeeApuConfig.class, name="apus", entry="apu")
    public void setApus(@Nullable ArrayList<StorageTeeApuConfig> apus) {
        this.funcGroupDelegate.setApus(apus);
    }

    @ElementList(inline=false, required=false, type=StorageTeeMpuBank.class, name="mpus", entry="mpu")
    public @ElementList(inline=false, required=false, type=StorageTeeMpuBank.class, name="mpus", entry="mpu") @Nullable ArrayList<StorageTeeMpuBank> getMpus() {
        return null;
    }

    @ElementList(inline=false, required=false, type=StorageTeeMpuBank.class, name="mpus", entry="mpu")
    public void setMpus(@Nullable ArrayList<StorageTeeMpuBank> mpus) {
        this.funcGroupDelegate.setMpus(mpus);
    }

    public List<StorageTeeFunctionalGroup> getFuncGroups() {
        return this.funcGroups != null ? this.funcGroups : new ArrayList<StorageTeeFunctionalGroup>();
    }

    public void setFuncGroups(List<StorageTeeFunctionalGroup> funcGroups) {
        this.funcGroups = funcGroups.isEmpty() ? null : funcGroups;
    }

    @Commit
    public void commit() {
        this.funcGroups = StorageTeeTool.prependFuncGroupDelegate(this.funcGroupDelegate, this.funcGroups);
        ArrayList<StorageTeeGlobalOption> toolOptionsLoc = this.teeProfile.getToolOptions();
        if (toolOptionsLoc == null) {
            for (StorageTeeFunctionalGroup storageFnGroup : this.getFuncGroups()) {
                if (toolOptionsLoc != null) continue;
                toolOptionsLoc = StorageTeeTool.collectToolOptions(storageFnGroup);
            }
            StorageTeeTool.eliminateToolOptions(this.getFuncGroups());
            this.teeProfile.setToolOptions(toolOptionsLoc);
        }
    }

    public static ArrayList<StorageTeeGlobalOption> collectToolOptions(StorageTeeFuncGroupDelegate funcGroupDelegate) {
        if (!funcGroupDelegate.isEmpty()) {
            return StorageTeeTool.collectToolOptions(funcGroupDelegate.getGlobalOptions());
        }
        return new ArrayList<StorageTeeGlobalOption>();
    }

    public static ArrayList<StorageTeeGlobalOption> collectToolOptions(StorageTeeFunctionalGroup funcGroup) {
        return StorageTeeTool.collectToolOptions(funcGroup.getGlobalOptions());
    }

    public static boolean isToolOption(String id) {
        return TOOL_OPTIONS.contains(id);
    }

    public static void updateToolOptions(Collection<? extends String> options) {
        TOOL_OPTIONS.addAll(options);
    }

    private static ArrayList<StorageTeeGlobalOption> collectToolOptions(@Nullable List<StorageTeeGlobalOption> globalOptions) {
        ArrayList<StorageTeeGlobalOption> toolOptions = new ArrayList<StorageTeeGlobalOption>();
        if (globalOptions != null) {
            for (StorageTeeGlobalOption globalOption : globalOptions) {
                if (!StorageTeeTool.isToolOption(globalOption.getId())) continue;
                toolOptions.add(globalOption);
            }
        }
        return toolOptions;
    }

    public static List<StorageTeeFunctionalGroup> eliminateToolOptions(List<StorageTeeFunctionalGroup> funcGroups) {
        for (StorageTeeFunctionalGroup funcGroup : funcGroups) {
            ArrayList<StorageTeeGlobalOption> globalOptions = funcGroup.getGlobalOptions();
            if (globalOptions == null) continue;
            globalOptions.removeAll(StorageTeeTool.collectToolOptions(globalOptions));
        }
        return funcGroups;
    }

    public static @Nullable List<StorageTeeFunctionalGroup> prependFuncGroupDelegate(StorageTeeFuncGroupDelegate funcGroupDelegate, @Nullable List<StorageTeeFunctionalGroup> funcGroups) {
        if (funcGroupDelegate.isEmpty()) {
            return funcGroups;
        }
        List<StorageTeeFunctionalGroup> funcGroupsLoc = funcGroups;
        if (funcGroupsLoc == null) {
            funcGroupsLoc = new ArrayList<StorageTeeFunctionalGroup>();
        }
        StorageTeeFunctionalGroup implicitFnGroup = new StorageTeeFunctionalGroup(funcGroupDelegate, !StorageTeeTool.defaultFgExists(funcGroupsLoc));
        implicitFnGroup.setName(INIT_FN_NAME);
        implicitFnGroup.setIdPrefix("");
        implicitFnGroup.setPrefixUserDefined(true);
        funcGroupsLoc.add(0, implicitFnGroup);
        return funcGroupsLoc;
    }

    private static boolean defaultFgExists(List<StorageTeeFunctionalGroup> funcGroups) {
        return funcGroups.stream().anyMatch(StorageTeeFunctionalGroup::isCalledFromInit);
    }

    public @Nullable List<StorageTeeFunctionalGroup> getFunctionalGroups() {
        return this.funcGroups;
    }

    public StorageTeeProfile getTeeProfile() {
        return this.teeProfile;
    }

    public void setTeeProfile(StorageTeeProfile teeProfile) {
        this.teeProfile = teeProfile;
    }

    @Override
    public void setDefaultVersion() {
        this.setVersion(TOOL_VERSION);
    }

    public IYamlStorable getYamlStorable() {
        YamlStorableList yamlStorable = new YamlStorableList("tee", Boolean.FALSE);
        List<StorageTeeFunctionalGroup> funcGroupsLoc = this.funcGroups;
        if (funcGroupsLoc != null) {
            YamlStorableList funcGroupsYaml = new YamlStorableList("functional_groups", Boolean.FALSE);
            funcGroupsLoc.forEach(apu -> apu.fillYamlStorable((IYamlStorable)funcGroupsYaml));
            yamlStorable.addYamlChild((IYamlStorable)funcGroupsYaml);
        }
        return yamlStorable;
    }

    public void fillYamlStorable(IYamlStorable yaml) {
        yaml.addYamlChild(this.getYamlStorable());
    }

    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        if (!yaml.getYamlId().equals("tee")) {
            return false;
        }
        this.funcGroupDelegate.loadFromYaml(yaml);
        ArrayList<StorageTeeFunctionalGroup> funcGroupsLoc = null;
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            if (childYaml.getYamlId().equals("functional_groups")) {
                ArrayList<StorageTeeFunctionalGroup> funcGroupsFromYaml = new ArrayList<StorageTeeFunctionalGroup>();
                Collection funcGroupsYaml = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"functional_groups");
                Iterator iterator = funcGroupsYaml.iterator();
                while (iterator.hasNext()) {
                    StorageTeeFunctionalGroup funcGroupStorable = new StorageTeeFunctionalGroup();
                    IYamlStorable funcGroupYaml = (IYamlStorable)iterator.next();
                    if (!funcGroupStorable.updateFromYamlStorable(funcGroupYaml)) continue;
                    funcGroupsFromYaml.add(funcGroupStorable);
                }
                funcGroupsLoc = funcGroupsFromYaml.isEmpty() ? null : funcGroupsFromYaml;
                continue;
            }
            LOGGER.severe("Unsupported YAML ID ignored during import: " + childYaml.getYamlId());
        }
        this.funcGroups = StorageTeeTool.prependFuncGroupDelegate(this.funcGroupDelegate, funcGroupsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * prime;
        result = result * prime + this.funcGroupDelegate.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, StorageTool.CompareMode mode) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        assert (other != null);
        if (this.getClass() != other.getClass()) {
            return false;
        }
        StorageTeeTool otherTee = (StorageTeeTool)other;
        return this.teeProfile.equals(otherTee.teeProfile) && Objects.equals(this.funcGroups, otherTee.funcGroups);
    }

    public static String getHexString(BigInteger addr) {
        return NumberFormatter.formatHexadecimalWithHexaPrefix((BigInteger)addr, (int)8);
    }
}

