/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeCheckerMemorySlaveConfig;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;

public class StorageTeeXrdc2CheckerSlaveConfig
extends StorageTeeCheckerMemorySlaveConfig {
    @Attribute(name="enabled", required=true)
    private boolean enabled = false;
    @Attribute(name="locked", required=true)
    private String locked = "";
    @Attribute(name="eal", required=false)
    private String eal = "";

    @Override
    protected void addUnderlyingYaml(List<IYamlStorable> storable) {
        super.addUnderlyingYaml(storable);
        storable.add((IYamlStorable)new YamlStorableValue("enabled", Boolean.toString(this.enabled)));
        storable.add((IYamlStorable)new YamlStorableValue("locked", this.locked));
        storable.add((IYamlStorable)new YamlStorableValue("eal", this.eal));
    }

    @Override
    protected boolean updatePropertyFromYaml(IYamlStorable yaml) {
        boolean updated = super.updatePropertyFromYaml(yaml);
        if (!updated) {
            String yamlId = yaml.getYamlId();
            if (yaml instanceof YamlStorableValue) {
                if (yamlId.equals("enabled")) {
                    this.setEnabled(Boolean.parseBoolean(yaml.getYamlValue()));
                    updated = true;
                } else if (yamlId.equals("locked")) {
                    this.setLocked(yaml.getYamlValue());
                    updated = true;
                } else if (yamlId.equals("eal")) {
                    this.setEal(yaml.getYamlValue());
                    updated = true;
                }
            }
        }
        return updated;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLocked(String locked) {
        this.locked = locked;
    }

    public String getLocked() {
        return this.locked;
    }

    public String getEal() {
        return this.eal;
    }

    public void setEal(String eal) {
        this.eal = eal;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.enabled, this.locked, this.eal);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeXrdc2CheckerSlaveConfig other = (StorageTeeXrdc2CheckerSlaveConfig)obj;
        return this.enabled == other.enabled && Objects.equals(this.locked, other.locked) && Objects.equals(this.eal, other.eal);
    }

    @Override
    public String toString() {
        return String.format("%s [%s, enabled=%s, locked=%s, eal=%s]", StorageTeeXrdc2CheckerSlaveConfig.class.getSimpleName(), super.toString(), Boolean.toString(this.enabled), this.locked, this.eal);
    }
}

