/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.sourceprovider;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class ConfigurationSourceProvider
extends AbstractSourceProvider {
    public static final String CONFIGURATION_IS_DIRTY = "com.nxp.swtools.configuration.isDirty";
    public static final String CONFIGURATION_IS_DEVICE_SELECTED = "com.nxp.swtools.configuration.isDeviceSelected";
    public static final String CONFIGURATION_IS_BOARD_OR_KIT_SELECTED = "com.nxp.swtools.configuration.isBoardOrKitSelected";
    public static final String CONFIGURATION_ENABLED_TOOLS = "com.nxp.swtools.configuration.enabledTools";
    public static final String CONFIGURATION_SUPPORTED_TOOLS = "com.nxp.swtools.configuration.supportedTools";
    public static final String CONFIGURATION_NOT_SUPPORTED_TOOLS = "com.nxp.swtools.configuration.notSupportedTools";
    public static final String CONFIGURATION_DEVICE = "com.nxp.swtools.configuration.device";
    @Nullable
    SharedConfigurationAdapter sharedConfigListener;
    @Nullable
    ISharedConfiguration sharedConfiguration;
    @Nullable
    Display display;
    @Nullable
    ISupportedDerivativesForSwTools derivatives;

    public void initialize(IServiceLocator locator) {
        this.display = Display.getCurrent();
        assert (this.display != null);
        this.derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        this.sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SharedConfigurationAdapter configListener = this.sharedConfigListener = new SharedConfigurationAdapter(){

            @Override
            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfig, @NonNull ConfigChangeReason reason) {
                ConfigurationSourceProvider.this.updateConfigurationState();
            }

            @Override
            public void configurationChanged(@NonNull ISharedConfiguration sharedConfig, @NonNull IConfigChangeContext changeContext) {
                if (changeContext.getChangeType() == IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE) {
                    ConfigurationSourceProvider.this.updateConfigurationState();
                }
            }

            @Override
            public void dirtyChanged(@NonNull ISharedConfiguration sharedConfig) {
                ConfigurationSourceProvider.this.updateConfigurationState();
            }

            @Override
            public int getListenerOrder() {
                return Integer.MAX_VALUE;
            }
        };
        if (this.sharedConfiguration != null) {
            this.sharedConfiguration.addListener(configListener);
        } else assert (false);
        super.initialize(locator);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        ISharedConfiguration cfg = this.sharedConfiguration;
        if (cfg == null) {
            assert (false);
        } else {
            map.put(CONFIGURATION_IS_DIRTY, cfg.isDirty());
            String mcu = cfg.getCommonConfig().getMcu();
            String sdk = cfg.getCommonConfig().getSdkVersion();
            map.put(CONFIGURATION_IS_DEVICE_SELECTED, !UtilsText.isEmpty((String)mcu));
            map.put(CONFIGURATION_DEVICE, mcu);
            String boardOrKit = cfg.getCommonConfig().getKitOrBoard();
            map.put(CONFIGURATION_IS_BOARD_OR_KIT_SELECTED, !UtilsText.isEmpty((String)boardOrKit));
            List enabledTools = cfg.getTools().getTools().stream().filter(StorageTool::isEnabled).map(StorageTool::getName).collect(Collectors.toList());
            map.put(CONFIGURATION_ENABLED_TOOLS, enabledTools);
            assert (this.derivatives != null);
            IProcessorMasterToolInfo info = this.derivatives.getProcessorMasterToolInfo(mcu, sdk);
            if (info != null) {
                List supportedTools = SwToolsProductConfiguration.getRegisteredProductsSorted().stream().filter(tool -> SupportedToolsByProcessor.isToolSuported((IProcessorMasterToolInfo)info, (String)tool.getProductId())).map(SwToolsProduct::getProductId).collect(Collectors.toList());
                map.put(CONFIGURATION_SUPPORTED_TOOLS, supportedTools);
                List notSupportedTools = SwToolsProductConfiguration.getRegisteredProductsSorted().stream().filter(tool -> SupportedToolsByProcessor.isToolDisabled((IProcessorMasterToolInfo)info, (String)tool.getProductId())).map(SwToolsProduct::getProductId).collect(Collectors.toList());
                map.put(CONFIGURATION_NOT_SUPPORTED_TOOLS, notSupportedTools);
            } else {
                map.put(CONFIGURATION_SUPPORTED_TOOLS, CollectionsUtils.emptyList());
                map.put(CONFIGURATION_NOT_SUPPORTED_TOOLS, CollectionsUtils.emptyList());
            }
        }
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{CONFIGURATION_IS_DIRTY, CONFIGURATION_IS_DEVICE_SELECTED, CONFIGURATION_IS_BOARD_OR_KIT_SELECTED, CONFIGURATION_ENABLED_TOOLS, CONFIGURATION_SUPPORTED_TOOLS, CONFIGURATION_NOT_SUPPORTED_TOOLS, CONFIGURATION_DEVICE};
    }

    public void dispose() {
        SharedConfigurationAdapter configListener = this.sharedConfigListener;
        if (configListener != null) {
            SharedConfigurationFactory.getSharedConfigurationSingleton().removeListener(configListener);
        }
        this.display = null;
    }

    public void updateConfigurationState() {
        Runnable r = () -> this.fireSourceChanged(0, this.getCurrentState());
        Display d = this.display;
        if (d != null && !Thread.currentThread().equals(d.getThread())) {
            if (d.isDisposed()) {
                return;
            }
            d.asyncExec(r);
        } else {
            r.run();
        }
    }
}

