/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.sdk.ISdkFileProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectInfo;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SdkExampleProjectSourceProvider
implements IToolchainProjectInfo {
    @NonNull
    private final ISdkFileProvider sdkFileProvider;
    @NonNull
    private final String exampleRelPath;
    @NonNull
    private final String slaveExampleRelPath;

    public SdkExampleProjectSourceProvider(@NonNull ISdkFileProvider sdkFileProvider, @NonNull String exampleRelPath, @Nullable String sharedSourcesPath) {
        this.sdkFileProvider = sdkFileProvider;
        this.exampleRelPath = UtilsFile.toEclipsePath((String)exampleRelPath);
        this.slaveExampleRelPath = UtilsFile.toEclipsePath((String)UtilsText.safeString((String)sharedSourcesPath));
    }

    @Override
    public @NonNull String getProjectName() {
        return UtilsFile.getFileNameWithExtension((String)this.exampleRelPath);
    }

    @Override
    public @NonNull Path getProjectRoot() {
        return Paths.get("", new String[0]);
    }

    @Override
    public @Nullable Path findSourceFileRelPath(@NonNull Path relPath) {
        Collection<@NonNull Path> files = this.listProjectSources(UtilsFile.getFileNameWithExtension((Path)relPath));
        if (files.isEmpty()) {
            return null;
        }
        return (Path)CollectionsUtils.first(files);
    }

    @Override
    public @NonNull Collection<@NonNull Path> listProjectSources(@NonNull String fileNameMask) {
        Collection<@NonNull String> result = this.sdkFileProvider.findMatchingFilesByMask(this.exampleRelPath, fileNameMask);
        if (!this.slaveExampleRelPath.isEmpty()) {
            result = new ArrayList<String>(result);
            result.addAll(this.sdkFileProvider.findMatchingFilesByMask(this.slaveExampleRelPath, fileNameMask));
        }
        if (result.isEmpty() && !this.slaveExampleRelPath.isEmpty()) {
            String parentPath = UtilsFile.getFilePath((String)this.exampleRelPath);
            assert (parentPath.equals(UtilsFile.getFilePath((String)this.slaveExampleRelPath)));
            result = this.sdkFileProvider.findMatchingFilesByMask(parentPath, fileNameMask);
        }
        return (Collection)result.stream().map(f -> Paths.get(f, new String[0])).collect(CollectorsUtils.toList());
    }

    @Override
    public @NonNull Collection<@NonNull Path> listProjectSourcesByRegEx(@NonNull Pattern fileNamePattern) {
        assert (false) : "not implemented yet, currently not needed for SDK examples";
        return new ArrayList<Path>();
    }

    @Override
    public @Nullable InputStream openSourceFile(@NonNull Path relPath) {
        return this.sdkFileProvider.openSdkFile(relPath.toString());
    }

    @Override
    public long getSourceModificationStamp(Path relPath) {
        assert (false);
        return -1L;
    }

    @Override
    public @NonNull Stream<@NonNull String> listFiles(@NonNull Path relDir) {
        return this.sdkFileProvider.findMatchingFilesByMask(relDir.toString(), "*.*").stream();
    }

    @Override
    public @NonNull Stream<@NonNull String> listSubDirectories(@NonNull Path relDir) {
        assert (false);
        return Stream.empty();
    }
}

