/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject.files;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;

public class ProjectFilesUtils {
    public static boolean fileExists(@NonNull IProjectFileAccess prjFiles, @NonNull Path filePath) {
        String fileName = Objects.requireNonNull(filePath.getFileName()).toString();
        Path fileDir = filePath.getParent();
        if (fileDir == null) {
            fileDir = Paths.get("", new String[0]);
        }
        return CollectionsUtils.findAny(prjFiles.listFiles(fileDir), f -> f.equals(fileName)) != null;
    }

    public static @NonNull Pattern createPatternForManifestFileMask(@NonNull String fileNameMask) {
        String fileNameRegEx = fileNameMask.replace(".", "\\.").replace("*", ".*");
        Pattern result = Pattern.compile(fileNameRegEx);
        assert (result != null);
        return result;
    }

    public static @Nullable Path recursivelyFindFile(@NonNull IProjectFileAccess prjFiles, @NonNull Path relDir, @NonNull String fileName) {
        Path result = relDir.resolve(fileName);
        assert (result != null);
        if (ProjectFilesUtils.fileExists(prjFiles, result)) {
            return result;
        }
        Iterator<@NonNull T> subDirs = prjFiles.listSubDirectories(relDir).iterator();
        while (subDirs.hasNext()) {
            String subDir = (String)subDirs.next();
            Path resolvedSubDir = relDir.resolve(subDir);
            assert (resolvedSubDir != null);
            result = ProjectFilesUtils.recursivelyFindFile(prjFiles, resolvedSubDir, fileName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void recursivelyFindFiles(@NonNull IProjectFileAccess prjFiles, @NonNull Path relDir, @NonNull Pattern fileName, @NonNull Collection<@NonNull String> result) {
        prjFiles.listFiles(relDir).filter(f -> fileName.matcher((CharSequence)f).matches()).forEach(f -> {
            boolean bl = result.add((String)f);
        });
        Iterator<@NonNull T> subDirs = prjFiles.listSubDirectories(relDir).iterator();
        while (subDirs.hasNext()) {
            String subDir = (String)subDirs.next();
            Path resolvedSubDir = relDir.resolve(subDir);
            assert (resolvedSubDir != null);
            ProjectFilesUtils.recursivelyFindFiles(prjFiles, resolvedSubDir, fileName, result);
        }
    }
}

