/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core;

import com.nxp.s32ds.ext.ide.core.ExtendedAction;
import com.nxp.s32ds.ext.ide.core.ExtendedActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExtendedActions {
    private static Map<String, Collection<ExtendedActionDescriptor>> type2actions = new HashMap<String, Collection<ExtendedActionDescriptor>>();

    public static Collection<ExtendedActionDescriptor> getExtendedActionsByType(String type) {
        return type2actions.get(type);
    }

    public static Collection<ExtendedActionDescriptor> getExtendedActionDescriptors() {
        return type2actions.values().stream().flatMap(x -> x.stream()).distinct().collect(Collectors.toList());
    }

    public static Collection<ExtendedAction> getExtendedActions() {
        return type2actions.values().stream().flatMap(x -> x.stream()).distinct().map(p -> p.getExtendedActionExecutor()).collect(Collectors.toList());
    }

    public static void addDescriptor(ExtendedActionDescriptor descriptor) {
        Collection<ExtendedActionDescriptor> collection = type2actions.computeIfAbsent(descriptor.getType(), new Function<String, Collection<ExtendedActionDescriptor>>(){

            @Override
            public Collection<ExtendedActionDescriptor> apply(String t) {
                return new ArrayList<ExtendedActionDescriptor>();
            }
        });
        collection.add(descriptor);
        type2actions.put(descriptor.getType(), collection);
    }
}

