/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.logging.PerformanceLogger;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.importer.IToolImporter;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import com.nxp.swtools.provider.toolchainproject.files.ProjectFileAccessFactory;
import com.nxp.swtools.sdkproject.ImportProjectResultStatus;
import com.nxp.swtools.sdkproject.ImportProjectResultStatusWithDescription;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.importer.PreparedImportStatus;
import com.nxp.swtools.utils.processors.ProcessorDataUpdateUI;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public final class ImportToolchainProjectFactory {
    private static final Logger LOGGER = LogManager.getLogger(ImportToolchainProjectFactory.class);
    public static final Logger PERFORMANCE_LOGGER = PerformanceLogger.getSharedPerformanceLogger();
    private static final String README_FILE_NAME = "readme.txt";
    private static final String NOT_IMPORT_REASON_PREFIX_IN_README = "This example cannot be imported into Config Tools because";

    private ImportToolchainProjectFactory() {
    }

    static void logError4User(@Nullable Shell shell, String msg) {
        LOGGER.severe(msg);
        if (shell != null) {
            UserLogger.error((String)msg, (String)"Toolchain/IDE project", (Display)shell.getDisplay());
        }
    }

    static void logWarning4User(@Nullable Shell shell, String msg) {
        LOGGER.warning(msg);
        if (shell != null) {
            UserLogger.warning((String)msg, (String)"Toolchain/IDE project", (Display)shell.getDisplay());
        }
    }

    private static boolean confirmWarnings(String warningMsgs) {
        if (warningMsgs.isEmpty()) {
            return true;
        }
        if (SWToolsProperties.isHeadlessOn() || SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode")) {
            return true;
        }
        Shell shell = ShellProvider.getAnyShellParent();
        AtomicBoolean answer = new AtomicBoolean(false);
        String msg = String.valueOf(warningMsgs) + "\r\n" + Messages.get().ImportToolchainProject_ContinueAnyway;
        shell.getDisplay().syncExec(() -> answer.set(MessageDialog.openQuestion((Shell)shell, (String)Messages.get().ImportToolchainProject_ContinueQuestion, (String)msg)));
        return answer.get();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable String importSourcesFromProject(@Nullable Shell shell, IToolchainProjectWithSdk srcProvider, ISharedConfiguration targetConfig, boolean createEmptyIfNoYaml, IProgressMonitor monitor, boolean importingAllProjects) {
        StringBuilder result = new StringBuilder();
        StringBuilder warnMsgs = new StringBuilder();
        PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "importSourcesFromProject");
        try {
            @NonNull Collection instances = ImportHelper.getImporters();
            if (instances.isEmpty()) {
                assert (false);
                String msg = "Failure: No importer instance found to import project";
                ImportToolchainProjectFactory.logError4User(shell, msg);
                String string = msg;
                return string;
            }
            ArrayList<@NonNull E> preparedImports = new ArrayList();
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(instances.size() * 2 + 1));
            instances.forEach(importer -> {
                PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "Prepare import by " + importer.getToolId());
                SubMonitor importProgress = sub.newChild(1);
                assert (importProgress != null);
                PreparedImportStatus importStatus = PreparedImportStatus.preparePrjImport((IToolImporter)importer, (IToolchainProjectWithSdk)srcProvider, null, (IProgressMonitor)importProgress);
                switch (importStatus.getResult()) {
                    case FAILED: 
                    case NO_YAML: 
                    case READY_FOR_IMPORT: {
                        preparedImports.add(importStatus);
                        break;
                    }
                }
                importProgress.done();
                PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "Prepare import by " + importer.getToolId());
                sub.worked(1);
            });
            if (result.length() == 0) {
                ISharedConfiguration masterConfig = null;
                String masterConfigToolId = "";
                for (PreparedImportStatus preparedImport : preparedImports) {
                    ISharedConfiguration toolConfig = preparedImport.getImportedConfiguration();
                    if (toolConfig.isEmpty()) continue;
                    if (masterConfig == null) {
                        masterConfig = toolConfig;
                        masterConfigToolId = preparedImport.getToolId();
                        continue;
                    }
                    String diff = masterConfig.getCommonConfig().compareWith(toolConfig.getCommonConfig(), true, masterConfigToolId, preparedImport.getToolId());
                    if (diff != null) {
                        String msg = String.valueOf(Messages.get().ImportToolchainProject_LogSharedCfgDoesNotMatch) + diff;
                        ImportToolchainProjectFactory.logError4User(shell, msg);
                        result.append(msg);
                        result.append("\r\n");
                        continue;
                    }
                    if (masterConfig.getCommonConfig().getBoard() != null || toolConfig.getCommonConfig().getBoard() == null) continue;
                    masterConfig = toolConfig;
                }
                if (masterConfig != null) {
                    KExProcessorsProvider.checkOrDownloadCommonConfig((IMcuIdentification)masterConfig.getCommonConfig().getMcuIdentification(), (IProgressMonitor)new NullProgressMonitor());
                }
                for (PreparedImportStatus preparedImport : preparedImports) {
                    if (preparedImport.isReadyForImport()) continue;
                    ITool tool = Tools.getTool((String)preparedImport.getToolId());
                    assert (tool != null);
                    if (masterConfig != null && !tool.isProcessorSupported(masterConfig)) continue;
                    String msg = String.valueOf(Messages.get().ImportToolchainProject_LogFailed) + preparedImport.getErrorMessage();
                    ImportToolchainProjectFactory.logError4User(shell, msg);
                    if (PreparedImportStatus.ImportResult.NO_YAML.equals((Object)preparedImport.getResult())) {
                        warnMsgs.append(msg);
                        warnMsgs.append("\r\n");
                        continue;
                    }
                    result.append(msg);
                    result.append("\r\n");
                }
                if (result.length() == 0) {
                    if (masterConfig == null) {
                        if (createEmptyIfNoYaml) {
                            return null;
                        }
                        String msg = Messages.get().ImportToolchainProject_LogNoSrcToImport;
                        if (shell == null) {
                            if (importingAllProjects && UtilsFile.convertToWinPathFormat((String)srcProvider.getProjectReference()).contains("_lib\\")) {
                                LOGGER.warning(msg);
                            } else {
                                LOGGER.severe("[SDK] " + msg);
                            }
                        } else {
                            ImportToolchainProjectFactory.logError4User(shell, msg);
                        }
                        if (targetConfig.isEmpty()) {
                            String string = msg;
                            return string;
                        }
                    } else {
                        if (!createEmptyIfNoYaml && !ImportToolchainProjectFactory.confirmWarnings(UtilsText.safeToString((Object)warnMsgs))) {
                            String string = Messages.get().ImportToolchainProject_ImportCanceledByUser;
                            return string;
                        }
                        if (targetConfig.isEmpty()) {
                            targetConfig.setMcuIdentification(masterConfig.getCommonConfig().getMcuIdentification());
                        } else {
                            String diff = targetConfig.getCommonConfig().compareWith(masterConfig.getCommonConfig(), true, UtilsText.safeString((String)Messages.get().ToolchainProjectCfgOpen_currentConfig), masterConfigToolId);
                            if (diff != null) {
                                String msg = String.valueOf(Messages.get().ImportToolchainProject_LogFailureDueToDifferences) + diff;
                                ImportToolchainProjectFactory.logError4User(shell, msg);
                                result.append(msg);
                            } else {
                                ProcessorCore selCore = targetConfig.getCommonConfig().getSelectedCore();
                                if (targetConfig.getCommonConfig().getBoard() == null && masterConfig.getCommonConfig().getBoard() != null || targetConfig.getCommonConfig().getKit() == null && masterConfig.getCommonConfig().getKit() != null) {
                                    KExProcessorsProvider.checkOrDownloadCommonConfig((IMcuIdentification)masterConfig.getCommonConfig().getMcuIdentification(), (IProgressMonitor)new NullProgressMonitor());
                                    targetConfig.setMcuIdentification(masterConfig.getCommonConfig().getMcuIdentification());
                                    if (targetConfig.getCommonConfig().getSelectedCore() == null && selCore != null) {
                                        targetConfig.getCommonConfig().setSelectedCore(selCore);
                                    }
                                }
                            }
                        }
                    }
                    if (UtilsText.isEmpty((String)targetConfig.getCommonConfig().getName())) {
                        targetConfig.setConfigurationName(targetConfig.getCommonConfig().getMcu());
                    }
                }
                sub.worked(1);
            }
            if (result.length() == 0) {
                boolean wasImported = false;
                for (PreparedImportStatus preparedImport : preparedImports) {
                    if (!preparedImport.isReadyForImport()) continue;
                    PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "Import by " + preparedImport.getToolId());
                    SubMonitor subMonitor = sub.newChild(1, 6);
                    assert (subMonitor != null);
                    StorageTool storageTool = preparedImport.getImportedStorageTool();
                    if (storageTool == null) {
                        result.append(String.format("Import in tool failed: %s. ", preparedImport.getToolId()));
                    } else {
                        assert (targetConfig.getTools().getTool(preparedImport.getToolId()) == null);
                        targetConfig.getTools().setTool(storageTool);
                        wasImported = true;
                    }
                    subMonitor.done();
                    PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "Import by " + preparedImport.getToolId());
                }
                if (wasImported) {
                    SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)targetConfig, (ISharedConfiguration)targetConfig, (ConfigChangeReason)ConfigChangeReason.RELOAD);
                }
            }
            sub.done();
        }
        finally {
            PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "importSourcesFromProject");
        }
        return result.length() == 0 ? null : result.toString();
    }

    public static ImportProjectResultStatusWithDescription importToolchainProject(@Nullable Shell shell, ISharedConfiguration configuration, IToolchainProjectWithSdk prj, boolean createEmptyIfNoYaml, IProgressMonitor monitor, boolean importingAllProjects) {
        String importMsg;
        String sdkVersion;
        String reasonToNoImport = ImportToolchainProjectFactory.findReasonToNotImportProject(prj);
        if (reasonToNoImport != null) {
            return importingAllProjects ? ImportProjectResultStatusWithDescription.ignored(reasonToNoImport) : ImportProjectResultStatusWithDescription.failed(reasonToNoImport);
        }
        if (!prj.wasProjectDetected()) {
            return ImportProjectResultStatusWithDescription.failed("No toolchain project detected for import in " + prj.getProjectReference());
        }
        String detectedProcessor = prj.getProcessor();
        if (detectedProcessor == null) {
            String msg = String.format(Messages.get().ImportToolchainProject_ErrProcessorNotDetectedOrNotSupported, prj.getToolchain(), prj.getProjectReference());
            ToolchainProjectFactory.LOGGER.severe("[NETWORK]" + msg);
            return ImportProjectResultStatusWithDescription.failed(msg);
        }
        String detectedPartNum = prj.getPartNumber();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String unsupportedMcuMsg = "";
        String string = sdkVersion = prj.getSdkVersion() != null ? prj.getSdkVersion() : SWToolsPlatform.getSdkVersionForProcessor((String)detectedProcessor);
        assert (sdkVersion != null);
        if (createEmptyIfNoYaml) {
            if (detectedPartNum == null || detectedPartNum.isEmpty()) {
                createEmptyIfNoYaml = false;
            } else {
                boolean processorAvailable;
                if (SWToolsProperties.isHeadlessOn()) {
                    processorAvailable = KExProcessorsProvider.checkOrDownloadProcessor((String)detectedProcessor, (String)sdkVersion, (boolean)true).isProcessorPresent();
                } else {
                    ProcessorDataUpdateUI.DisplayProvider disp = ProcessorDataUpdateUI.DisplayProvider.create((Control)shell);
                    DownloadStatus processorDownloaded = ProcessorDataUpdateUI.updateAndGetProcessorStatus((ProcessorDataUpdateUI.DisplayProvider)disp, (String)detectedProcessor, (String)sdkVersion, (IProgressMonitor)subMon.newChild(40, 0));
                    processorAvailable = processorDownloaded.isCurrentOrUpdated();
                    ProcessorDataUpdateUI.downloadOrUpdateComponents((ProcessorDataUpdateUI.DisplayProvider)disp, (String)detectedProcessor, (String)sdkVersion, (IProgressMonitor)subMon.newChild(40, 0));
                }
                if (!processorAvailable) {
                    createEmptyIfNoYaml = false;
                    unsupportedMcuMsg = String.format(Messages.get().ImportToolchainProject_ErrProcessorNotSupportedOrNotDownloaded, detectedProcessor);
                    ImportToolchainProjectFactory.logError4User(shell, unsupportedMcuMsg);
                    ISupportedDerivativesForSwTools suppDerivs = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                    if (suppDerivs.getProcessorInfoForPartNumber(detectedPartNum) == null) {
                        createEmptyIfNoYaml = false;
                    }
                }
            }
        }
        if ((importMsg = ImportToolchainProjectFactory.importSourcesFromProject(shell, prj, configuration, createEmptyIfNoYaml, (IProgressMonitor)subMon.newChild(20, 0), importingAllProjects)) != null) {
            return ImportProjectResultStatusWithDescription.failed(unsupportedMcuMsg.isEmpty() ? importMsg : unsupportedMcuMsg);
        }
        if (configuration.isEmpty()) {
            assert (detectedPartNum != null);
            IMcuIdentification mcuIdent = McuSelectionFactory.createMcuSelectionIdentification((String)detectedProcessor, (String)detectedPartNum, (String)sdkVersion, null, null, null);
            configuration.setMcuIdentification(mcuIdent);
        }
        if (!configuration.isEmpty()) {
            configuration.getCommonConfig().setDescription("Configuration imported from " + prj.getProjectReference());
            String prjCoreId = prj.getCoreId();
            if (configuration.getCommonConfig().getSelectedCore() == null && prjCoreId != null) {
                configuration.getCommonConfig().getCores().forEach(c -> {
                    if (c.getID().equals(prjCoreId)) {
                        configuration.getCommonConfig().setSelectedCore(c);
                    }
                });
            }
        }
        return ImportProjectResultStatusWithDescription.succeed();
    }

    private static @Nullable String findReasonToNotImportProject(IToolchainProjectWithSdk prj) {
        java.nio.file.Path defaultReadMePath;
        ArrayList<@NonNull java.nio.file.Path> readMeFiles = new ArrayList<java.nio.file.Path>(prj.listProjectSources(README_FILE_NAME));
        if (!readMeFiles.contains(defaultReadMePath = Paths.get("doc", README_FILE_NAME)) && prj.getSourceModificationStamp(defaultReadMePath) > 0L) {
            readMeFiles.add(defaultReadMePath);
        }
        for (java.nio.file.Path readFile : readMeFiles) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream is = prj.openSourceFile(readFile);){
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
                    String reasonToNotImport = (String)CollectionsUtils.findAny(reader.lines(), l -> l.contains(NOT_IMPORT_REASON_PREFIX_IN_README));
                    if (reasonToNotImport == null) continue;
                    return reasonToNotImport.substring(reasonToNotImport.indexOf(NOT_IMPORT_REASON_PREFIX_IN_README));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    public static @Nullable String getExistingMexPathForProject(String importPath) {
        IProjectFileAccess prjFiles = ProjectFileAccessFactory.getProjectFileAccess((java.nio.file.Path)Paths.get(importPath, new String[0]));
        String mexFilePath = (String)CollectionsUtils.findAny((Stream)prjFiles.listFiles(Paths.get("", new String[0])), p -> p.endsWith(".mex"));
        if (mexFilePath != null && UtilsFile.getFilePath((String)mexFilePath).isEmpty()) {
            mexFilePath = String.valueOf(importPath) + File.separator + mexFilePath;
        }
        return mexFilePath;
    }

    public static boolean saveMexAfterProjectImport(ISharedConfiguration importedConfig, ISharedConfiguration tgtConfig, String mexFilePath, @Nullable Shell shell, StringBuilder outLogMsg) {
        PERFORMANCE_LOGGER.entering(ImportToolchainProjectFactory.class.getName(), "saveMexAfterProjectImport");
        try {
            importedConfig.setLocationPath(Path.fromOSString((String)mexFilePath));
            tgtConfig.setLocationPath(importedConfig.getLocationPath());
            SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)importedConfig, (ISharedConfiguration)tgtConfig, (ConfigChangeReason)ConfigChangeReason.LOAD_CONFIG);
            ConfigurationUtils.saveConfiguration((Shell)shell, (boolean)false);
            outLogMsg.append(String.valueOf(Messages.get().ImportToolchainProject_LogMexFileSaved) + mexFilePath);
        }
        finally {
            PERFORMANCE_LOGGER.exiting(ImportToolchainProjectFactory.class.getName(), "saveMexAfterProjectImport");
        }
        return true;
    }

    public static @Nullable String createConfigurationForS32Project(IToolchainProjectWithSdk project, String path, IProgressMonitor monitor) {
        ProcessorCore core;
        String selCore;
        File preSetMex;
        if (!project.wasProjectDetected()) {
            return "No toolchain project detected in " + project.getProjectReference();
        }
        ISharedConfiguration importedSharedCfg = SharedConfigurationFactory.createSharedConfiguration();
        ImportProjectResultStatusWithDescription status = ImportToolchainProjectFactory.importToolchainProject(null, importedSharedCfg, project, true, monitor, false);
        if (!ImportProjectResultStatus.SUCCEED.equals((Object)status.getStatus())) {
            return status.getDescription();
        }
        importedSharedCfg.setConfigurationName(importedSharedCfg.getCommonConfig().getMcu());
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        String sdkVersion = UtilsText.safeString((String)project.getSdkVersion());
        String processor = UtilsText.safeString((String)project.getProcessor());
        IProcessorMasterToolInfo procLocal = derivatives.getProcessorMasterToolInfo(processor, sdkVersion);
        if (procLocal != null && (preSetMex = new File(String.valueOf(derivatives.getDataDir()) + File.separator + procLocal.getSubDir() + File.separator + project.getPartNumber() + ".mex")).exists()) {
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (InputStream is = UtilsDecryption.getFileInputStream((File)preSetMex);){
                    SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)importedSharedCfg, (InputStream)is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ((selCore = project.getCoreId()) != null && (core = importedSharedCfg.getCommonConfig().findCore(selCore)) != null) {
            importedSharedCfg.getCommonConfig().setSelectedCore(core);
        }
        Tools.enableToolsWithSupportedProcessor((ISharedConfiguration)importedSharedCfg);
        Tools.disableToolsWithUnsupportedProcessor((ISharedConfiguration)importedSharedCfg);
        importedSharedCfg.setLocationPath(Path.fromOSString((String)path));
        String file = ConfigurationUtils.saveConfiguration(null, (ISharedConfiguration)importedSharedCfg, (boolean)false);
        if (file == null) {
            return "Could not save " + path + " in " + project.getProjectReference();
        }
        return null;
    }
}

