/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.internal;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FileChangesWatcher {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(FileChangesWatcher.class);
    @NonNull
    static final @NonNull Map<@NonNull Path, Watcher> watchers = new HashMap<Path, Watcher>();

    static @Nullable WatchService createWatchService() {
        if (Rap.isActive()) {
            return null;
        }
        try {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException | UnsupportedOperationException e) {
            LOGGER.log(Level.SEVERE, "WatchService cannot be used, changes in toolchain project file will not be detected", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addListener(@NonNull Path path, @NonNull IFileChangeListener listener) {
        assert (path.isAbsolute()) : "addListener.isAbsolute " + Objects.toString(path);
        assert (path.equals(path.normalize()));
        Path dir = path.getParent();
        assert (dir != null);
        Map<Path, Watcher> map = watchers;
        synchronized (map) {
            Watcher watcher = watchers.get(dir);
            if (watcher == null) {
                if (!dir.toFile().isDirectory()) {
                    return false;
                }
                WatchService service = FileChangesWatcher.createWatchService();
                if (service == null) {
                    return false;
                }
                watcher = new Watcher(dir, service);
                watchers.put(dir, watcher);
            }
            watcher.addWatchedFile(new WatchedFile(Objects.requireNonNull(path.getFileName()).toString(), listener));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(@NonNull Path path, @NonNull IFileChangeListener listener) {
        Map<Path, Watcher> map = watchers;
        synchronized (map) {
            Path dir = path.getParent();
            assert (dir != null);
            Watcher watcher = watchers.get(dir);
            if (watcher != null) {
                if (watcher.removeListener(new WatchedFile(Objects.requireNonNull(path.getFileName()).toString(), listener))) {
                    watchers.remove(dir);
                    watcher.close();
                }
            } else assert (false);
        }
    }

    public static interface IFileChangeListener {
        public void fileChanged(boolean var1);
    }

    private static class WatchedFile {
        @NonNull
        final String fileName;
        @NonNull
        final IFileChangeListener listener;

        WatchedFile(@NonNull String fileName, @NonNull IFileChangeListener listener) {
            this.fileName = fileName;
            this.listener = listener;
        }

        public int hashCode() {
            return this.fileName.hashCode() * 31 + this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WatchedFile other = (WatchedFile)obj;
            return this.fileName.equals(other.fileName) && this.listener.equals(other.listener);
        }
    }

    private static class Watcher {
        @NonNull
        final WatchService service;
        @NonNull
        final Job watchJob;
        @Nullable
        WatchKey watchKey;
        @NonNull
        @NonNull Collection<@NonNull WatchedFile> watchedFiles = CollectionsUtils.emptyUnmodifiableList();

        Watcher(final @NonNull Path path, final @NonNull WatchService service) {
            this.service = service;
            this.watchJob = new Job("Project file changes watcher in " + path.toString()){

                protected IStatus run(IProgressMonitor wMonitor) {
                    try {
                        WatchService ws = service;
                        if (!$assertionsDisabled && ws == null) {
                            throw new AssertionError();
                        }
                        watchKey = path.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        while (!wMonitor.isCanceled()) {
                            WatchKey wKey;
                            try {
                                wKey = ws.take();
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            catch (ClosedWatchServiceException closedWatchServiceException) {
                                break;
                            }
                            HashMap<@NonNull K, V> notifyListeners = new HashMap();
                            for (WatchEvent<?> event : wKey.pollEvents()) {
                                WatchEvent.Kind<?> kind = event.kind();
                                if (StandardWatchEventKinds.OVERFLOW.equals(kind)) {
                                    watchedFiles.forEach(wf -> {
                                        Boolean bl = notifyListeners.put(wf.listener, Boolean.TRUE);
                                    });
                                    continue;
                                }
                                WatchEvent<?> ev = event;
                                Path filenamePath = (Path)ev.context();
                                if (filenamePath != null) {
                                    String filename = filenamePath.toString();
                                    watchedFiles.forEach(wf -> {
                                        if (filename.equals(wf.fileName)) {
                                            notifyListeners.put(wf.listener, Boolean.TRUE);
                                        }
                                    });
                                }
                                if (!StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) continue;
                                watchedFiles.forEach(wf -> {
                                    if (!notifyListeners.containsKey(wf.listener)) {
                                        notifyListeners.put(wf.listener, Boolean.FALSE);
                                    }
                                });
                            }
                            boolean valid = wKey.reset();
                            if (!wMonitor.isCanceled()) {
                                if (!valid) {
                                    watchedFiles.forEach(wf -> {
                                        Boolean bl = notifyListeners.put(wf.listener, Boolean.TRUE);
                                    });
                                }
                                notifyListeners.entrySet().forEach(e -> {
                                    IFileChangeListener listener = (IFileChangeListener)e.getKey();
                                    listener.fileChanged((Boolean)e.getValue());
                                });
                                if (valid) {
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        if (!wMonitor.isCanceled()) {
                            watchKey = null;
                        }
                        LOGGER.log(Level.SEVERE, "Project file cannot be watched for changes " + path);
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            this.watchJob.setSystem(true);
            this.watchJob.schedule();
        }

        void addWatchedFile(@NonNull WatchedFile watchedFile) {
            if (!this.watchedFiles.contains(watchedFile)) {
                @NonNull HashSet<@NonNull WatchedFile> newWatchedFiles = new HashSet<WatchedFile>(this.watchedFiles);
                newWatchedFiles.add(watchedFile);
                this.watchedFiles = newWatchedFiles;
            }
        }

        boolean removeListener(@NonNull WatchedFile watchedFile) {
            if (this.watchedFiles.contains(watchedFile)) {
                @NonNull HashSet<@NonNull WatchedFile> newWatchedFiles = new HashSet<WatchedFile>(this.watchedFiles);
                newWatchedFiles.remove(watchedFile);
                this.watchedFiles = newWatchedFiles;
            }
            return this.watchedFiles.isEmpty();
        }

        public void close() {
            this.watchJob.cancel();
            final WatchKey watchKeyToCancel = this.watchKey;
            if (watchKeyToCancel != null) {
                this.watchKey = null;
                Job j = new Job("Cancel WatchKey"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            service.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Failed to close watch service", e);
                        }
                        watchKeyToCancel.cancel();
                        return Status.OK_STATUS;
                    }
                };
                j.setSystem(true);
                j.schedule();
            }
        }
    }
}

