/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.updateprojectcode;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.sdkproject.ToolSourceFileProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.graphics.Image;

public final class TreeItemData {
    @Nullable
    private final TreeItemData parent;
    @NonNull
    private final ItemType itemType;
    @NonNull
    private final String text;
    @NonNull
    private String tooltip;
    @Nullable
    private Image icon;
    @NonNull
    private final @NonNull List<@NonNull TreeItemData> children;
    @NonNull
    private Selection selection;
    @Nullable
    private String fileStatusLabel;
    @Nullable
    private Runnable actionRunnable;
    @Nullable
    private Image fileStatusIcon;
    @Nullable
    private ToolSourceFileProvider toolSourceProvider;
    private boolean isForRemoval;
    private boolean isDerived;

    private TreeItemData(@Nullable TreeItemData parent, @NonNull ItemType type, @NonNull String text, @Nullable ToolSourceFileProvider toolSrcProvider, @Nullable String tooltip) {
        assert (!UtilsText.isEmpty((String)tooltip));
        this.parent = parent;
        this.itemType = type;
        this.text = text;
        this.toolSourceProvider = toolSrcProvider;
        this.tooltip = UtilsText.safeString((String)tooltip);
        this.selection = Selection.SELECTED;
        this.children = new ArrayList<TreeItemData>();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    static @NonNull TreeItemData newRootItem(@NonNull String text, @Nullable ToolSourceFileProvider toolSourceProvider, @Nullable String tooltip) {
        return new TreeItemData(null, ItemType.TOOL, text, toolSourceProvider, tooltip);
    }

    static @NonNull TreeItemData newItem(@NonNull TreeItemData parent, @NonNull ItemType type, @NonNull String text, @Nullable String tooltip) {
        return new TreeItemData(parent, type, text, null, tooltip);
    }

    public @Nullable TreeItemData getParent() {
        return this.parent;
    }

    public @NonNull ItemType getItemType() {
        return this.itemType;
    }

    public @NonNull String getText() {
        return this.text;
    }

    public @Nullable ToolSourceFileProvider getToolSourceFileProvider() {
        return this.toolSourceProvider;
    }

    public @NonNull String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(@NonNull String newTooltip) {
        this.tooltip = newTooltip;
    }

    public void addChild(@NonNull TreeItemData child) {
        assert (!this.itemType.equals((Object)ItemType.FILE));
        this.children.add(child);
        this.updateSelection();
    }

    public @NonNull Selection getSelection() {
        return this.selection;
    }

    public void setSelection(@NonNull Selection state) {
        if (this.selection == state) {
            return;
        }
        this.selection = state;
        if (!state.equals((Object)Selection.NOT_UNIQUE) && !state.equals((Object)Selection.CANNOT_SELECT)) {
            for (TreeItemData item : this.getChildren()) {
                if (Selection.CANNOT_SELECT.equals((Object)item.getSelection())) continue;
                item.setSelection(state);
            }
        }
        if (this.parent != null) {
            this.parent.updateSelection();
        }
    }

    public boolean toggleSelection() {
        switch (this.getSelection()) {
            case SELECTED: 
            case NOT_UNIQUE: {
                this.setSelection(Selection.UNSELECTED);
                return true;
            }
            case UNSELECTED: {
                this.setSelection(Selection.SELECTED);
                return true;
            }
            case ALWAYS_SELECTED: 
            case NEVER_SELECTED: 
            case CANNOT_SELECT: {
                assert (false);
                break;
            }
        }
        return false;
    }

    void updateSelection() {
        Selection childrenState = null;
        for (TreeItemData item : this.children) {
            Selection itemSel = item.getSelection();
            if (Selection.CANNOT_SELECT.equals((Object)itemSel)) continue;
            if (childrenState == null) {
                childrenState = itemSel;
                continue;
            }
            if (childrenState == itemSel) continue;
            this.setSelection(Selection.NOT_UNIQUE);
            return;
        }
        if (childrenState == null) {
            childrenState = Selection.CANNOT_SELECT;
        }
        this.setSelection(childrenState);
    }

    public @Nullable Image getIcon() {
        return this.icon;
    }

    public void setIcon(@NonNull Image newIcon) {
        this.icon = newIcon;
    }

    public void setFileStatus(@NonNull Image icon, @NonNull String label, @Nullable Runnable runnable) {
        this.fileStatusIcon = icon;
        this.fileStatusLabel = label;
        this.actionRunnable = runnable;
    }

    public @Nullable Image getFileStatusIcon() {
        return this.fileStatusIcon;
    }

    public @Nullable String getFileStatusLabel() {
        return this.fileStatusLabel;
    }

    public @Nullable Runnable getFileStatusAction() {
        return this.actionRunnable;
    }

    public @NonNull List<@NonNull TreeItemData> getChildren() {
        return CollectionsUtils.unmodifiableList(this.children);
    }

    public @NonNull String getPath(char separator) {
        StringBuilder result = new StringBuilder();
        if (this.parent != null) {
            result.append(this.parent.getPath(separator));
        }
        switch (this.getItemType()) {
            case TOOL: {
                return "";
            }
            case FOLDER: 
            case FILE: {
                result.append(this.getText().replace(File.pathSeparatorChar, separator));
            }
        }
        return result.toString();
    }

    public @NonNull GeneratedProjectFile toGeneratedProjectFile() {
        assert (ItemType.FILE.equals((Object)this.getItemType()));
        GeneratedProjectFile result = new GeneratedProjectFile(this.getPath('/'), true, this.isDerived);
        if (!this.getSelection().isChecked()) {
            TreeItemData toolItem = this;
            while (toolItem.getParent() != null) {
                toolItem = Objects.requireNonNull(toolItem.getParent());
            }
            if (toolItem.getSelection().isChecked()) {
                result.setUpdateEnabled(false);
            }
        }
        return result;
    }

    public boolean isForRemoval() {
        return this.isForRemoval;
    }

    public void setForRemoval(boolean value) {
        this.isForRemoval = value;
    }

    public boolean isDerived() {
        return this.isDerived;
    }

    public void setDerived(boolean value) {
        this.isDerived = value;
    }

    public String toString() {
        return String.valueOf(String.valueOf((Object)this.itemType)) + ": " + this.getText();
    }

    static enum ItemType {
        TOOL,
        FOLDER,
        FILE;

    }

    static enum Selection {
        SELECTED,
        UNSELECTED,
        NOT_UNIQUE,
        ALWAYS_SELECTED,
        NEVER_SELECTED,
        CANNOT_SELECT;


        public boolean isChecked() {
            return this.equals((Object)SELECTED) || this.equals((Object)ALWAYS_SELECTED) || this.equals((Object)NOT_UNIQUE);
        }

        public boolean isGrayed() {
            return this.equals((Object)NEVER_SELECTED) || this.equals((Object)CANNOT_SELECT) || this.equals((Object)ALWAYS_SELECTED) || this.equals((Object)NOT_UNIQUE);
        }

        public boolean isReadOnly() {
            return this.equals((Object)NEVER_SELECTED) || this.equals((Object)CANNOT_SELECT) || this.equals((Object)ALWAYS_SELECTED);
        }
    }

    static class TreeItemDataWithColumn {
        @NonNull
        final TreeItemData data;
        final int column;

        protected TreeItemDataWithColumn(@NonNull TreeItemData data, int column) {
            this.data = data;
            this.column = column;
        }
    }
}

