/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core;

import com.nxp.s32ds.debug.ide.core.DebuggerBackend;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.BoardConnectionDescriptor;
import com.nxp.s32ds.debug.ide.s32debugger.core.ProcessCheckingJob;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.core.S32DebuggerSemihostingProcess;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class S32DebuggerBackend
extends DebuggerBackend {
    private static final String SEMIHOSTING_PROCESS_NAME = "Semihosting";
    private static final String PATH_TO_GDB_SERVER_DIRECTORY = "${S32DS_GDB_SERVER_DIR}";
    private static final String PATH_TO_GDB_SERVER_EXECUTABLE = "${S32DS_GDB_SERVER_EXECUTABLE_PATH}";
    private static final String PORT_PARAMETER_PREFIX = "-p";
    private static final String DEBUG_PROBE_PARAMETER_PREFIX = "-t";
    private IProcess semihostingProcessWrapper;
    private boolean launchServer;

    public S32DebuggerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.launchServer = S32DebuggerParams.getParams((ILaunchConfiguration)lc).isDoLaunchServer();
    }

    public void initialize(RequestMonitor rm) {
        if (this.launchServer) {
            if (S32DSGdbServerProcess.isServerRunning()) {
                rm.done((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", S32DebuggerErrorMessages.S32DebuggerGTAFull_session_close));
                return;
            }
            try {
                String port = this.lc.getAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.serverPortNumber", "45000");
                this.server = this.launchGdbServer(new String[]{this.getCommandLine(), PORT_PARAMETER_PREFIX, port}, this.getWorkingDirectory());
                if (this.server == null) {
                    throw new CoreException(S32DebuggerErrorStatuses.getGDBServerStartFailedStatus());
                }
            }
            catch (CoreException ex) {
                rm.done(ex.getStatus());
                return;
            }
        }
        super.initialize(rm);
    }

    public File getWorkingDirectory() {
        Path path = Paths.get(DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_DIRECTORY), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return new File(DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_DIRECTORY));
        }
        return null;
    }

    public String getCommandLine() {
        return S32DebuggerBackend.getServerExecutable();
    }

    public String getProcessName() {
        return "S32 Debugger";
    }

    public void initializeSemihostingConsole(String port) {
        int semiHostingPort = -1;
        try {
            semiHostingPort = Integer.valueOf(port);
            if (semiHostingPort <= 0 || semiHostingPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (Exception exception) {
            S32DebuggerCoreActivator.getDefault().logError("Invalid semihosting port.");
            return;
        }
        S32DebuggerSemihostingProcess semihostingProcess = new S32DebuggerSemihostingProcess("localhost", semiHostingPort);
        semihostingProcess.submit();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            S32DebuggerCoreActivator.getDefault().logError("Interrupted during sleep for semihosting console. " + e.getMessage());
        }
        this.semihostingProcessWrapper = DebugPlugin.newProcess((ILaunch)this.s32dsGdbLaunch, (Process)semihostingProcess, (String)SEMIHOSTING_PROCESS_NAME);
        this.semihostingProcessWrapper.setAttribute(IProcess.ATTR_PROCESS_LABEL, DebuggerUtils.generateProcessName((ILaunchConfiguration)this.lc, (String)SEMIHOSTING_PROCESS_NAME));
    }

    public void shutdown(RequestMonitor requestMonitor) {
        if (this.semihostingProcessWrapper != null) {
            try {
                this.semihostingProcessWrapper.terminate();
            }
            catch (DebugException debugException) {
                S32DebuggerCoreActivator.getDefault().logError("Cannot terminate Eclipse semihosting wrapper process!");
            }
        }
        super.shutdown(requestMonitor);
    }

    public static String getServerExecutable() {
        return DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_EXECUTABLE);
    }

    public static BoardConnectionDescriptor isBoardConnected(String deviceStr, ProcessCheckingJob processCheckingJob) throws IOException {
        Process process = null;
        try {
            BoardConnectionDescriptor boardConnectionDescriptor;
            block18: {
                String[] cmdarray = new String[]{S32DebuggerBackend.getServerExecutable(), DEBUG_PROBE_PARAMETER_PREFIX, deviceStr};
                process = Runtime.getRuntime().exec(cmdarray);
                processCheckingJob.setProcess(process);
                processCheckingJob.setProcessActiveStatus(true);
                processCheckingJob.schedule();
                Throwable throwable = null;
                Object var5_7 = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    Properties boardConenctionStrings = new Properties();
                    for (String line : reader.lines().collect(Collectors.toList())) {
                        String[] properties = line.split(":");
                        if (properties.length != 2) {
                            throw new IOException(S32DebuggerErrorMessages.S32DebuggerBoardConnection_wrong_answer_format);
                        }
                        boardConenctionStrings.put(properties[0], properties[1].replaceAll(" ", ""));
                    }
                    boardConnectionDescriptor = BoardConnectionDescriptor.createFromProperties(boardConenctionStrings);
                    if (reader == null) break block18;
                }
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                reader.close();
            }
            return boardConnectionDescriptor;
        }
        finally {
            if (process != null) {
                process.destroy();
                processCheckingJob.setProcessActiveStatus(false);
            }
        }
    }
}

